/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.kapott.hbci.GV.GVWPDepotUms;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRWPDepotList;
import org.kapott.hbci.GV_Result.GVRWPDepotUms;
import org.kapott.hbci.callback.HBCICallbackConsole;
import org.kapott.hbci.manager.FileSystemClassLoader;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;

public final class DepotAbrufTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HBCIPassport passport = null;
        HBCIHandler hbciHandle = null;
        HBCIUtils.init(HBCIUtils.loadPropertiesFile(new FileSystemClassLoader(), "/home/jonas/java/hbci/jw.hbci4java.properties"), new MyHBCICallback());
        String passportDescription = "Passport f\u00fcr Kontoauszugs-Demo";
        passport = AbstractHBCIPassport.getInstance((Object)passportDescription);
        try {
            String line;
            String version = passport.getHBCIVersion();
            hbciHandle = new HBCIHandler(version.length() != 0 ? version : "plus", passport);
            System.out.println("Alle Gesch\u00e4ftsvorf\u00e4lle in HBCI4Java: " + hbciHandle.getKernel().getAllLowlevelJobs().toString());
            System.out.println("Unterst\u00fctzte Gesch\u00e4ftsvorf\u00e4lle der Bank: " + hbciHandle.getSupportedLowlevelJobs().toString());
            System.out.println("Kontenliste:");
            System.out.println("------------");
            Konto[] konten = passport.getAccounts();
            for (int i = 0; i < konten.length; ++i) {
                System.out.println("Konto " + i + ":  " + konten[i]);
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(System.in));
            int umsatzkto = -1;
            int depotkto = -1;
            System.out.print("Bitte Konto f\u00fcr Umsatzliste eingeben (-1, um zu \u00fcberspringen): ");
            do {
                line = rd.readLine();
                try {
                    umsatzkto = Integer.parseInt(line);
                    if (umsatzkto >= -1 && umsatzkto < konten.length) break;
                    System.out.println("Ung\u00fcltiges Konto: " + line);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } while (line != null);
            System.out.print("Bitte Konto f\u00fcr Depotliste eingeben (-1, um zu \u00fcberspringen): ");
            do {
                line = rd.readLine();
                try {
                    depotkto = Integer.parseInt(line);
                    if (depotkto >= -1 && depotkto < konten.length) break;
                    System.out.println("Ung\u00fcltiges Konto: " + line);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } while (line != null);
            if (umsatzkto >= 0) {
                DepotAbrufTest.analyzeReportOfTransactions(passport, hbciHandle, konten[umsatzkto]);
            }
            if (depotkto >= 0) {
                DepotAbrufTest.analyzeDepot(passport, hbciHandle, konten[depotkto]);
            }
        }
        finally {
            if (hbciHandle != null) {
                hbciHandle.close();
            } else if (passport != null) {
                passport.close();
            }
        }
    }

    private static void analyzeReportOfTransactions(HBCIPassport hbciPassport, HBCIHandler hbciHandle, Konto myaccount) {
        HBCIJob auszug = hbciHandle.newJob("KUmsAll");
        auszug.setParam("my", myaccount);
        auszug.addToQueue();
        HBCIExecStatus ret = hbciHandle.execute();
        GVRKUms result = (GVRKUms)auszug.getJobResult();
        if (result.isOK()) {
            System.out.println("##############################");
            System.out.println("#####    Umsatzliste   #######");
            System.out.println("##############################");
            System.out.println(result.toString());
        } else {
            System.out.println("Job-Error");
            System.out.println(result.getJobStatus().getErrorString());
            System.out.println("Global Error");
            System.out.println(ret.getErrorString());
        }
    }

    private static void analyzeDepot(HBCIPassport hbciPassport, HBCIHandler hbciHandle, Konto myaccount) {
        myaccount.curr = null;
        HBCIJob auszug = hbciHandle.newJob("WPDepotList");
        auszug.setParam("my", myaccount);
        auszug.addToQueue();
        HBCIExecStatus ret = hbciHandle.execute();
        GVRWPDepotList result = (GVRWPDepotList)auszug.getJobResult();
        if (result.isOK()) {
            System.out.println("##############################");
            System.out.println("#####    Depotliste    #######");
            System.out.println("##############################");
            System.out.println(result.toString());
        } else {
            System.out.println("Job-Error");
            System.out.println(result.getJobStatus().getErrorString());
            System.out.println("Global Error");
            System.out.println(ret.getErrorString());
        }
        if (!hbciHandle.getSupportedLowlevelJobs().containsKey("WPDepotUms")) {
            System.out.println("Abruf der Depotums\u00e4tze nicht unterst\u00fctzt!");
        } else {
            HBCIJob ums = hbciHandle.newJob("WPDepotUms");
            ums.setParam("my", myaccount);
            ums.addToQueue();
            ret = hbciHandle.execute();
            GVRWPDepotUms umsRes = (GVRWPDepotUms)ums.getJobResult();
            if (umsRes.isOK()) {
                System.out.println("################################");
                System.out.println("#####    Depotums\u00e4tze    #######");
                System.out.println("################################");
                System.out.println(umsRes.toString());
            } else {
                System.out.println("Job-Error");
                System.out.println(umsRes.getJobStatus().getErrorString());
                System.out.println("Global Error");
                System.out.println(ret.getErrorString());
            }
        }
    }

    private static void test_ums(HBCIHandler hbciHandle, String fileName) {
        try {
            int sz;
            MyGVUms test = new MyGVUms(hbciHandle);
            FileReader rd = new FileReader(fileName);
            StringBuilder res = new StringBuilder();
            char[] buf = new char[4000];
            while ((sz = rd.read(buf)) >= 0) {
                res.append(buf, 0, sz);
            }
            rd.close();
            System.out.println(test.myExtract(res.toString()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class MyGVUms
    extends GVWPDepotUms {
        public MyGVUms(HBCIHandler handler) {
            super(handler);
        }

        public GVRWPDepotUms myExtract(String testdata) {
            HBCIMsgStatus stat = new HBCIMsgStatus();
            stat.getData().put("foo.data536", testdata);
            this.extractResults(stat, "foo", 0);
            return (GVRWPDepotUms)this.jobResult;
        }
    }

    private static class MyHBCICallback
    extends HBCICallbackConsole {
        private MyHBCICallback() {
        }

        @Override
        public void callback(HBCIPassport passport, int reason, String msg, int dataType, StringBuffer retData) {
            if (reason == 25 || reason == 24) {
                return;
            }
            System.out.println("Callback f\u00fcr folgendes Passport: " + passport.getClientData("init").toString() + ", reason=" + reason);
            super.callback(passport, reason, msg, dataType, retData);
        }
    }
}

