/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;

public class ParameterFinder {
    public static Properties find(Properties props, Query query) {
        return ParameterFinder.find(props, query != null ? query.getQuery() : null);
    }

    public static Properties find(Properties props, String path) {
        if (path == null || path.length() == 0) {
            return props != null ? props : new Properties();
        }
        Properties next = new Properties();
        String[] keys = path.split("\\.");
        String key = keys[0];
        boolean endsWith = key.startsWith("*");
        boolean startsWith = key.endsWith("*");
        key = key.replace("*", "");
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String[] names = name.split("\\.");
            if (startsWith && !endsWith && !names[0].startsWith(key) || !startsWith && endsWith && !names[0].endsWith(key) || startsWith && endsWith && !names[0].contains(key) || !startsWith && !endsWith && !names[0].equals(key)) continue;
            String newName = name.substring(name.indexOf(".") + 1);
            next.put(newName, props.getProperty(name));
        }
        if (!path.contains(".")) {
            return next;
        }
        return ParameterFinder.find(next, path.substring(path.indexOf(".") + 1));
    }

    public static Properties findAll(Properties props, Query query) {
        return ParameterFinder.findAll(props, query != null ? query.getQuery() : null);
    }

    public static Properties findAll(Properties props, String path) {
        String[] keys;
        if (path == null || path.length() == 0) {
            return props != null ? props : new Properties();
        }
        Properties rest = new Properties();
        rest.putAll((Map<?, ?>)props);
        for (int i = 0; i < 100 && (keys = path.split("\\.")).length >= i + 1; ++i) {
            String key = keys[i];
            boolean endsWith = key.startsWith("*");
            boolean startsWith = key.endsWith("*");
            key = key.replace("*", "");
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                boolean b4;
                String name = (String)e.nextElement();
                String[] names = name.split("\\.");
                if (names.length < i + 1) {
                    rest.remove(name);
                    continue;
                }
                boolean b1 = startsWith && !endsWith && names[i].startsWith(key);
                boolean b2 = !startsWith && endsWith && names[i].endsWith(key);
                boolean b3 = startsWith && endsWith && names[i].contains(key);
                boolean bl = b4 = !startsWith && !endsWith && names[i].equals(key);
                if (b1 || b2 || b3 || b4) continue;
                rest.remove(name);
            }
        }
        return rest;
    }

    public static String getValue(Properties props, Query query, String defaultValue) {
        return ParameterFinder.getValue(props, query != null ? query.getQuery() : null, defaultValue);
    }

    public static String getValue(Properties props, String path, String defaultValue) {
        String s;
        Properties result = ParameterFinder.findAll(props, path);
        if (result == null || result.size() == 0) {
            return defaultValue;
        }
        if (result.size() > 1) {
            HBCIUtils.log("query " + path + " mode ambiguous, found multiple values: " + result, 3);
        }
        return (s = (String)result.values().iterator().next()) != null ? s : defaultValue;
    }

    public static class Query {
        public static final Query BPD_PINTAN_CAN1STEP = new Query("Params_*.TAN2StepPar*.ParTAN2Step*.can1step", false);
        public static final Query BPD_PINTAN_ORDERHASHMODE = new Query("Params_*.TAN2StepPar{0}.ParTAN2Step*.orderhashmode", true);
        private String query = null;
        private boolean paramsSet = false;

        private Query(String q, boolean needParams) {
            this.query = q;
            this.paramsSet = !needParams;
        }

        public final Query withParameters(Object ... parameters) {
            return new Query(MessageFormat.format(this.query, parameters), false);
        }

        public String getQuery() {
            if (!this.paramsSet) {
                throw new HBCI_Exception("Parameters not set in query: " + this.query);
            }
            return this.query;
        }
    }
}

