/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci;

import de.willuhn.jameica.hbci.HBCICallbackSWT;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.CustomDateFormat;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.server.DBSupportH2Impl;
import de.willuhn.jameica.hbci.server.HBCIDBServiceImpl;
import de.willuhn.jameica.messaging.BootMessage;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.plugin.AbstractPlugin;
import de.willuhn.jameica.plugin.Version;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.CustomDecimalFormat;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.callback.HBCICallbackConsole;
import org.kapott.hbci.manager.HBCIUtils;

public class HBCI
extends AbstractPlugin {
    public static final boolean COMPLETE_IBAN = Boolean.FALSE;
    public static DateFormat LONGDATEFORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    public static DateFormat XTRALONGDATEFORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    public static DateFormat DATEFORMAT = new CustomDateFormat("dd.MM.yyyy");
    public static DateFormat SHORTDATEFORMAT = new CustomDateFormat("dd.MM.");
    public static DateFormat FASTDATEFORMAT = new SimpleDateFormat("ddMMyyyy");
    public static DecimalFormat DECIMALFORMAT = new CustomDecimalFormat();
    public static final HashMap LOGMAPPING = new HashMap();
    private static final String HBCI4JAVA_VERSION = "3.1.79";
    private HBCICallback callback = null;
    private Properties hbciProps = null;

    public void init() throws ApplicationException {
        Logger.info((String)"starting init process for hibiscus");
        DECIMALFORMAT.setGroupingUsed(Settings.getDecimalGrouping());
        LOGMAPPING.put(Level.ERROR, 1);
        LOGMAPPING.put(Level.WARN, 2);
        LOGMAPPING.put(Level.INFO, 3);
        LOGMAPPING.put(Level.DEBUG, 4);
        LOGMAPPING.put(Level.TRACE, 5);
        this.call(new ServiceCall(){

            @Override
            public void call(HBCIDBService service) throws ApplicationException, RemoteException {
                service.checkConsistency();
            }
        });
        String path = String.valueOf(Settings.getWorkPath()) + "/passports/";
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        this.initHBCI(this.getResources().getSettings().getString("hbcicallback.class", HBCICallbackSWT.class.getName()));
        Application.getCallback().getStartupMonitor().addPercentComplete(5);
    }

    public void install() throws ApplicationException {
        this.call(new ServiceCall(){

            @Override
            public void call(HBCIDBService service) throws ApplicationException, RemoteException {
                service.install();
            }
        });
    }

    public void uninstall(boolean deleteUserData) throws ApplicationException {
        if (!deleteUserData) {
            return;
        }
        try {
            Logger.info((String)"deleting hibiscus wallet");
            Settings.getWallet().deleteAll(null);
        }
        catch (Exception e) {
            Logger.error((String)"unable to delete wallet", (Throwable)e);
        }
    }

    public final synchronized void initHBCI(String callbackClass) throws ApplicationException {
        Application.getCallback().getStartupMonitor().setStatusText("hibiscus: init hbci4java subsystem");
        try {
            block29: {
                File addonprops;
                if (this.callback != null) {
                    try {
                        HBCIUtils.done();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.callback = null;
                BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
                if (callbackClass != null && callbackClass.length() > 0) {
                    try {
                        Class<?> c = Class.forName(callbackClass);
                        this.callback = (HBCICallback)service.get(c);
                        Logger.info((String)("callback: " + this.callback.getClass().getName()));
                    }
                    catch (Throwable t) {
                        Logger.error((String)"unable to load custom callback - fallback to default", (Throwable)t);
                    }
                }
                if (this.callback == null) {
                    this.callback = Application.inServerMode() ? new HBCICallbackConsole() : (HBCICallback)service.get(HBCICallbackSWT.class);
                }
                this.hbciProps = new Properties();
                Version v = this.getManifest().getVersion();
                this.hbciProps.put("client.product.name", "A44C2953982351617D475443E");
                this.hbciProps.put("client.product.version", String.valueOf(v.getMajor()) + "." + v.getMinor());
                this.hbciProps.put("passport.format", "LegacyFormat");
                this.hbciProps.put("passport.format.HBCIPassportPinTan", "AESFormat");
                this.hbciProps.put("passport.format.HBCIPassportDDV", "AESFormat");
                this.hbciProps.put("passport.format.HBCIPassportDDVPCSC", "AESFormat");
                this.hbciProps.put("passport.format.HBCIPassportDDVRSA", "AESFormat");
                this.hbciProps.put("passport.format.HBCIPassportRAH10", "AESFormat");
                this.hbciProps.put("passport.format.HBCIPassportRDHNew", "LegacyFormat");
                int logLevel = 3;
                try {
                    logLevel = (Integer)LOGMAPPING.get(Logger.getLevel());
                }
                catch (Exception e) {
                    Logger.warn((String)"unable to map jameica log level into hbci4java log level. using default");
                }
                this.hbciProps.put("log.loglevel.default", "" + logLevel);
                this.hbciProps.put("client.errors.ignoreWrongDataSyntaxErrors", "yes");
                if (Logger.isLogging((Level)Level.DEBUG)) {
                    this.hbciProps.put("log.ssl.enable", "1");
                }
                if ((addonprops = new File(this.getResources().getWorkPath(), "hbci4java.properties")).exists()) {
                    InputStream is = null;
                    try {
                        try {
                            is = new BufferedInputStream(new FileInputStream(addonprops));
                            Properties p = new Properties();
                            p.load(is);
                            if (p.size() > 0) {
                                Logger.info((String)("applying hbci4java properties from " + addonprops + ": " + p.toString()));
                                this.hbciProps.putAll((Map<?, ?>)p);
                            }
                        }
                        catch (Exception e) {
                            Logger.error((String)("unable to load " + addonprops), (Throwable)e);
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Exception e2) {
                                    Logger.error((String)("error while closing " + addonprops), (Throwable)e2);
                                }
                            }
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception e) {
                                Logger.error((String)("error while closing " + addonprops), (Throwable)e);
                            }
                        }
                        throw throwable;
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception e) {
                            Logger.error((String)("error while closing " + addonprops), (Throwable)e);
                        }
                    }
                }
            }
            HBCIUtils.init((Properties)this.hbciProps, (HBCICallback)this.callback);
            String version = HBCIUtils.version();
            if (version != null && !HBCI4JAVA_VERSION.equals(version)) {
                String s = "Die Version der Systembibliothek HBCI4Java \"{0}\" stimmt nicht mit der erwarteten Version \"{1}\" \u00fcberein. Das wird zu unerwarteten Fehlern f\u00fchren. Bitte kopiere eine neuere Version von Hibiscus nicht \u00fcber die vorherige dr\u00fcber. Hierbei k\u00f6nnen Fragmente der vorherigen Version erhalten bleiben. Installiere Updates stattdessen per \"Datei->Einstellungen->Plugins\".";
                Application.getMessagingFactory().getMessagingQueue("jameica.boot").queueMessage((Message)new BootMessage(this.getResources().getI18N().tr("Die Version der Systembibliothek HBCI4Java \"{0}\" stimmt nicht mit der erwarteten Version \"{1}\" \u00fcberein. Das wird zu unerwarteten Fehlern f\u00fchren. Bitte kopiere eine neuere Version von Hibiscus nicht \u00fcber die vorherige dr\u00fcber. Hierbei k\u00f6nnen Fragmente der vorherigen Version erhalten bleiben. Installiere Updates stattdessen per \"Datei->Einstellungen->Plugins\".", new String[]{version, HBCI4JAVA_VERSION})));
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to init HBCI4Java", (Throwable)e);
            throw new ApplicationException(this.getResources().getI18N().tr("Fehler beim Initialisieren des HBCI-Subsystems"), (Throwable)e);
        }
    }

    public HBCICallback getHBCICallback() {
        return this.callback;
    }

    public Properties getHBCIPropetries() {
        return this.hbciProps;
    }

    private void call(ServiceCall call) throws ApplicationException {
        if (Application.inClientMode()) {
            return;
        }
        HBCIDBServiceImpl service = null;
        try {
            try {
                service = new HBCIDBServiceImpl();
                service.start();
                call.call(service);
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (Exception e) {
                Logger.error((String)"unable to init db service", (Throwable)e);
                I18N i18n = this.getResources().getI18N();
                String msg = i18n.tr("Hibiscus-Datenbank konnte nicht initialisiert werden.\n\n{0} ", e.getMessage());
                String driver = HBCIDBService.SETTINGS.getString("database.driver", null);
                if (driver != null && driver.equals(DBSupportH2Impl.class.getName())) {
                    msg = String.valueOf(msg) + "\n\nM\u00f6glicherweise ist die Hibiscus-Datenbank defekt. Klicken Sie bitte auf \"Datei>Backups verwalten\", w\u00e4hlen Sie das Backup vom letzten Tag aus, an dem der Fehler noch nicht auftrat und klicken Sie anschlie\u00dfend auf \"Ausgew\u00e4hltes Backup wiederherstellen...\". Beim n\u00e4chsten Start von Hibiscus wird das Backup automatisch wiederhergestellt. Sollte sich das Problem hierdurch nicht beheben lassen, besuchen Sie bitte http://www.willuhn.de/wiki/doku.php?id=support:fehlermelden";
                }
                throw new ApplicationException(msg, (Throwable)e);
            }
        }
        finally {
            if (service != null) {
                try {
                    service.stop(true);
                }
                catch (Exception e) {
                    Logger.error((String)"error while closing db service", (Throwable)e);
                }
            }
        }
    }

    private static interface ServiceCall {
        public void call(HBCIDBService var1) throws ApplicationException, RemoteException;
    }
}

