/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.AbstractHibiscusHBCICallback;
import de.willuhn.jameica.hbci.AccountContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.gui.DialogFactory;
import de.willuhn.jameica.hbci.gui.dialogs.NewInstKeysDialog;
import de.willuhn.jameica.hbci.gui.dialogs.NewKeysDialog;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.passport.PassportHandle;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Nachricht;
import de.willuhn.jameica.hbci.synchronize.SynchronizeSession;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.security.Wallet;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.Base64;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.eclipse.swt.SWTException;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.NeedKeyAckException;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class HBCICallbackSWT
extends AbstractHibiscusHBCICallback {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Map<HBCIPassport, AccountContainer> accountCache = new HashMap<HBCIPassport, AccountContainer>();
    private PassportHandle currentHandle = null;
    @Resource
    private HBCISynchronizeBackend backend = null;

    public void log(String msg, int level, Date date, StackTraceElement trace) {
        SynchronizeSession session = this.backend.getCurrentSession();
        boolean mon = true;
        String type = null;
        switch (level) {
            case 5: 
            case 6: {
                Logger.trace((String)msg);
                mon = false;
                break;
            }
            case 4: {
                Logger.debug((String)msg);
                mon = false;
                break;
            }
            case 3: {
                this.updateProgress();
                Logger.info((String)msg);
                break;
            }
            case 2: {
                this.updateProgress();
                type = "Hinweis";
                if (msg != null && (msg.startsWith("konnte folgenden nutzerdefinierten Wert nicht in Nachricht einsetzen:") || msg.startsWith("could not insert the following user-defined data"))) {
                    Logger.debug((String)msg);
                    mon = false;
                    break;
                }
                if (msg != null && msg.matches(".* Algorithmus .* nicht implementiert")) {
                    Logger.debug((String)msg);
                    mon = false;
                    break;
                }
                Logger.warn((String)msg);
                break;
            }
            case 1: {
                this.updateProgress();
                if (session != null && session.getStatus() == 5) {
                    mon = false;
                    break;
                }
                if (session != null && msg != null) {
                    session.getErrors().add(msg.replace("HBCI error code: ", ""));
                }
                type = "Fehler";
                Logger.error((String)(String.valueOf(msg) + " " + trace.toString()));
                break;
            }
            default: {
                Logger.warn((String)msg);
            }
        }
        if (mon && session != null) {
            ProgressMonitor monitor = session.getProgressMonitor();
            if (type != null) {
                monitor.log("    [" + type + "] " + msg);
            } else {
                monitor.log("    " + msg);
            }
        }
    }

    public void callback(HBCIPassport passport, int reason, String msg, int datatype, StringBuffer retData) {
        this.updateProgress();
        SynchronizeSession session = this.backend.getCurrentSession();
        try {
            if (this.currentHandle != null && this.currentHandle.callback(passport, reason, msg, datatype, retData)) {
                Logger.debug((String)("callback [reason " + reason + "] handled by " + this.currentHandle.getClass()));
                return;
            }
            AccountContainer container = this.accountCache.get(passport);
            switch (reason) {
                case 21: 
                case 22: {
                    Wallet w = Settings.getWallet();
                    String pw = (String)((Object)w.get("hbci.passport.password." + passport.getClass().getName()));
                    if (pw != null && pw.length() > 0) {
                        Logger.debug((String)("using passport key from wallet, passport: " + passport.getClass().getName()));
                        retData.replace(0, retData.length(), pw);
                    } else {
                        Logger.debug((String)("creating new random passport key, passport: " + passport.getClass().getName()));
                        byte[] pass = new byte[8];
                        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                        random.nextBytes(pass);
                        pw = Base64.encode((byte[])pass);
                        w.set("hbci.passport.password." + passport.getClass().getName(), (Serializable)((Object)pw));
                        retData.replace(0, retData.length(), pw);
                    }
                    break;
                }
                case 24: {
                    if (!Settings.getOnlineMode()) {
                        Application.getCallback().notifyUser(i18n.tr("Bitte stellen Sie eine Internetverbindung her und klicken Sie anschlie\u00dfend auf OK."));
                    }
                    break;
                }
                case 25: {
                    if (!Settings.getOnlineMode()) {
                        Application.getCallback().notifyUser(i18n.tr("Sie k\u00f6nnen die Internetverbindung nun wieder trennen."));
                    }
                    break;
                }
                case 7: {
                    if (container == null) {
                        container = DialogFactory.getAccountData(passport);
                    }
                    this.accountCache.put(passport, container);
                    retData.replace(0, retData.length(), container.country);
                    break;
                }
                case 8: {
                    if (container == null) {
                        container = DialogFactory.getAccountData(passport);
                    }
                    this.accountCache.put(passport, container);
                    retData.replace(0, retData.length(), container.blz);
                    break;
                }
                case 9: {
                    if (container == null) {
                        container = DialogFactory.getAccountData(passport);
                    }
                    this.accountCache.put(passport, container);
                    retData.replace(0, retData.length(), container.host);
                    break;
                }
                case 10: {
                    if (container == null) {
                        container = DialogFactory.getAccountData(passport);
                    }
                    this.accountCache.put(passport, container);
                    retData.replace(0, retData.length(), String.valueOf(container.port));
                    break;
                }
                case 26: {
                    if (container == null) {
                        container = DialogFactory.getAccountData(passport);
                    }
                    this.accountCache.put(passport, container);
                    retData.replace(0, retData.length(), container.filter);
                    break;
                }
                case 11: {
                    if (container == null) {
                        container = DialogFactory.getAccountData(passport);
                    }
                    this.accountCache.put(passport, container);
                    retData.replace(0, retData.length(), container.userid);
                    break;
                }
                case 18: {
                    if (container == null) {
                        container = DialogFactory.getAccountData(passport);
                    }
                    this.accountCache.put(passport, container);
                    retData.replace(0, retData.length(), container.customerid);
                    break;
                }
                case 12: {
                    NewInstKeysDialog nikd = new NewInstKeysDialog(passport);
                    Boolean b = (Boolean)nikd.open();
                    retData.replace(0, retData.length(), b != false ? "" : "ERROR");
                    break;
                }
                case 13: {
                    NewKeysDialog nkd = new NewKeysDialog(passport);
                    try {
                        nkd.open();
                    }
                    catch (OperationCanceledException e) {
                        Logger.warn((String)e.getMessage());
                    }
                    break;
                }
                case 14: {
                    try {
                        Konto k = session.getKonto();
                        boolean sm = true;
                        if (k != null) {
                            SynchronizeOptions o = new SynchronizeOptions(k);
                            sm = o.getSyncMessages();
                        }
                        if (sm) {
                            Nachricht n = (Nachricht)Settings.getDBService().createObject(Nachricht.class, null);
                            n.setBLZ(passport.getBLZ());
                            n.setNachricht(msg);
                            n.setDatum(new Date());
                            n.store();
                            String text = i18n.tr("Neue Institutsnachricht empfangen");
                            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(text, 2));
                            Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)n));
                            session.getProgressMonitor().setStatusText(text);
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to store system message", (Throwable)e);
                        Application.getCallback().notifyUser(msg);
                    }
                    break;
                }
                case 19: 
                case 30: {
                    if (Settings.getKontoCheck()) {
                        Logger.error((String)("IBAN/CRC error: " + msg + " [" + retData.toString() + "]: "));
                    }
                    break;
                }
                case 40: {
                    Logger.error((String)("detected wrong PIN: " + msg + " [" + retData.toString() + "]: "));
                    break;
                }
                case 41: {
                    Logger.info((String)"got changed user/account data (code 3072) - saving in persistent data for later handling");
                    ((AbstractHBCIPassport)passport).setPersistentData("hibiscus.context.userid.changed", (Object)retData.toString());
                    break;
                }
                case 20: {
                    Logger.error((String)("NOT IMPLEMENTED: " + msg + " [" + retData.toString() + "]: "));
                    throw new HBCI_Exception("reason not implemented");
                }
                default: {
                    Logger.error((String)("unknown reason " + reason + ", datatype: " + datatype + ": " + msg));
                    throw new HBCI_Exception("unknown reason " + reason + ": " + msg);
                }
            }
        }
        catch (NeedKeyAckException e) {
            session.cancel();
        }
        catch (OperationCanceledException oce) {
            if (session != null) {
                session.cancel();
            }
            throw oce;
        }
        catch (Throwable t) {
            Throwable th;
            if (t instanceof SWTException) {
                t = ((SWTException)t).throwable;
            }
            if ((th = HBCIProperties.getCause(t, OperationCanceledException.class)) != null) {
                session.cancel();
                throw (OperationCanceledException)th;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new HBCI_Exception(t);
        }
    }

    @Override
    protected void status(String text) {
        Logger.info((String)text);
        if (!Logger.isLogging((Level)Level.DEBUG)) {
            return;
        }
        SynchronizeSession session = this.backend.getCurrentSession();
        this.updateProgress();
        if (session != null) {
            ProgressMonitor monitor = session.getProgressMonitor();
            monitor.log(String.valueOf(text) + "\n");
        }
    }

    private void updateProgress() {
        SynchronizeSession session = this.backend.getCurrentSession();
        if (session == null) {
            return;
        }
        ProgressMonitor m = session.getProgressMonitor();
        if (m == null) {
            return;
        }
        double window = session.getProgressWindow();
        if (window <= 1.0) {
            return;
        }
        m.addPercentComplete(1);
        session.setProgressWindow(window - 0.2);
    }

    public void setCurrentHandle(PassportHandle handle) {
        this.currentHandle = handle;
    }
}

