/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci;

import de.jost_net.OBanToo.SEPA.BankenDaten.Bank;
import de.jost_net.OBanToo.SEPA.BankenDaten.Banken;
import de.jost_net.OBanToo.SEPA.IBAN;
import de.jost_net.OBanToo.SEPA.IBANCode;
import de.jost_net.OBanToo.SEPA.SEPAException;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.AddressbookService;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.structures.Konto;

public class HBCIProperties {
    private static de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(HBCIProperties.class);
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    public static final String HBCI_DTAUS_VALIDCHARS;
    public static final String HBCI_SEPA_VALIDCHARS;
    public static final String HBCI_SEPA_MANDATE_VALIDCHARS;
    public static final String HBCI_SEPA_PMTINF_VALIDCHARS;
    public static final String HBCI_IBAN_VALIDCHARS;
    public static final String HBCI_BIC_VALIDCHARS;
    public static final String HBCI_SEPA_PURPOSECODE_VALIDCHARS;
    public static final String HBCI_BLZ_VALIDCHARS;
    public static final String HBCI_BZU_VALIDCHARS;
    public static final String HBCI_KTO_VALIDCHARS;
    public static final int HBCI_TRANSFER_USAGE_MAXLENGTH;
    public static final int HBCI_TRANSFER_USAGE_DB_MAXLENGTH;
    public static final int HBCI_GVCODE_MAXLENGTH;
    public static final int HBCI_ADDKEY_MAXLENGTH;
    public static final int HBCI_TRANSFER_BZU_LENGTH;
    public static final int HBCI_SEPATRANSFER_USAGE_MAXLENGTH;
    public static final int HBCI_TRANSFER_USAGE_MAXNUM;
    public static final int HBCI_KTO_MAXLENGTH_SOFT;
    public static final int HBCI_KTO_MAXLENGTH_HARD;
    public static final int HBCI_IBAN_MAXLENGTH;
    public static final int HBCI_BIC_MAXLENGTH;
    public static final int HBCI_ID_MAXLENGTH;
    public static final int HBCI_LAST_OF_MONTH;
    public static final int HBCI_BLZ_LENGTH;
    public static final int HBCI_TRANSFER_NAME_MAXLENGTH;
    public static final String CURRENCY_DEFAULT_DE;
    public static final int HBCI_PIN_MAXLENGTH;
    public static final int HBCI_PIN_MINLENGTH;
    public static final int UMSATZ_DEFAULT_DAYS;
    public static final int HBCI_SEPA_ENDTOENDID_MAXLENGTH;
    public static final int HBCI_SEPA_PURPOSECODE_MAXLENGTH;
    public static final int HBCI_SEPA_MANDATEID_MAXLENGTH;
    public static final int HBCI_SEPA_CREDITORID_MAXLENGTH;
    public static final boolean HBCI_SEPA_PARSE_TAGS;
    public static final String[][] TEXT_REPLACEMENTS_SEPA;
    public static final String[][] TEXT_REPLACEMENTS_UMSATZ;
    private static final Map<SEPAException.Fehler, String> obantooCodes;
    private static final List<SEPAException.Fehler> ignoredErrors;

    static {
        settings.setStoreWhenRead(false);
        HBCI_DTAUS_VALIDCHARS = settings.getString("hbci.dtaus.validchars", "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 ,.&-+*%/$\u00fc\u00f6\u00e4\u00dc\u00d6\u00c4\u00df");
        HBCI_SEPA_VALIDCHARS = settings.getString("hbci.sepa.validchars", "abcdefghijklmnopqrstuvwxyz\u00fc\u00f6\u00e4\u00dfABCDEFGHIJKLMNOPQRSTUVWXYZ\u00dc\u00d6\u00c40123456789':?,- (+.)/&*$%");
        HBCI_SEPA_MANDATE_VALIDCHARS = settings.getString("hbci.sepa.mandate.validchars", "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789':?,-(+.)/");
        HBCI_SEPA_PMTINF_VALIDCHARS = String.valueOf(HBCI_SEPA_MANDATE_VALIDCHARS) + " ";
        HBCI_IBAN_VALIDCHARS = settings.getString("hbci.iban.validchars", "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
        HBCI_BIC_VALIDCHARS = settings.getString("hbci.bic.validchars", "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
        HBCI_SEPA_PURPOSECODE_VALIDCHARS = settings.getString("hbci.sepa.purposecode.validchars", "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        HBCI_BLZ_VALIDCHARS = settings.getString("hbci.blz.validchars", "0123456789");
        HBCI_BZU_VALIDCHARS = settings.getString("hbci.bzu.validchars", "0123456789");
        HBCI_KTO_VALIDCHARS = settings.getString("hbci.kto.validchars", "0123456789");
        HBCI_TRANSFER_USAGE_MAXLENGTH = settings.getInt("hbci.transfer.usage.maxlength", 27);
        HBCI_TRANSFER_USAGE_DB_MAXLENGTH = settings.getInt("hbci.transfer.usage.db.maxlength", 35);
        HBCI_GVCODE_MAXLENGTH = settings.getInt("hbci.gvcode.maxlength", 3);
        HBCI_ADDKEY_MAXLENGTH = settings.getInt("hbci.addkey.maxlength", 3);
        HBCI_TRANSFER_BZU_LENGTH = settings.getInt("hbci.transfer.bzu.length", 13);
        HBCI_SEPATRANSFER_USAGE_MAXLENGTH = settings.getInt("hbci.foreigntransfer.usage.maxlength", 140);
        HBCI_TRANSFER_USAGE_MAXNUM = settings.getInt("hbci.transfer.usage.maxnum", 14);
        HBCI_KTO_MAXLENGTH_SOFT = settings.getInt("hbci.kto.maxlength.soft", 16);
        HBCI_KTO_MAXLENGTH_HARD = settings.getInt("hbci.kto.maxlength.hard", 10);
        HBCI_IBAN_MAXLENGTH = settings.getInt("hbci.iban.maxlength", 34);
        HBCI_BIC_MAXLENGTH = settings.getInt("hbci.bic.maxlength", 11);
        HBCI_ID_MAXLENGTH = settings.getInt("hbci.id.maxlength", 30);
        HBCI_LAST_OF_MONTH = settings.getInt("hbci.lastofmonth", 99);
        HBCI_BLZ_LENGTH = settings.getInt("hbci.blz.maxlength", 8);
        HBCI_TRANSFER_NAME_MAXLENGTH = settings.getInt("hbci.transfer.name.maxlength", 70);
        CURRENCY_DEFAULT_DE = settings.getString("currency.default.de", "EUR");
        HBCI_PIN_MAXLENGTH = settings.getInt("hbci.pin.maxlength", 50);
        HBCI_PIN_MINLENGTH = settings.getInt("hbci.pin.minlength", 5);
        UMSATZ_DEFAULT_DAYS = settings.getInt("umsatz.default.days", 30);
        HBCI_SEPA_ENDTOENDID_MAXLENGTH = settings.getInt("hbci.sepa.endtoendid.maxlength", 35);
        HBCI_SEPA_PURPOSECODE_MAXLENGTH = settings.getInt("hbci.sepa.purposecode.maxlength", 4);
        HBCI_SEPA_MANDATEID_MAXLENGTH = settings.getInt("hbci.sepa.mandateid.maxlength", 35);
        HBCI_SEPA_CREDITORID_MAXLENGTH = settings.getInt("hbci.sepa.creditorid.maxlength", 35);
        HBCI_SEPA_PARSE_TAGS = settings.getBoolean("hbci.sepa.parsetags", true);
        TEXT_REPLACEMENTS_SEPA = new String[][]{{"&", "*", "%", "$", "\u00fc", "\u00f6", "\u00e4", "\u00dc", "\u00d6", "\u00c4", "\u00df"}, {"+", ".", ".", ".", "ue", "oe", "ae", "Ue", "Oe", "Ae", "ss"}};
        TEXT_REPLACEMENTS_UMSATZ = new String[][]{{"\n", "\r"}, {"", ""}};
        obantooCodes = new HashMap<SEPAException.Fehler, String>(){
            {
                this.put(SEPAException.Fehler.BLZ_LEER, i18n.tr("Keine BLZ angegeben"));
                this.put(SEPAException.Fehler.BLZ_UNGUELTIGE_LAENGE, i18n.tr("BLZ nicht achtstellig"));
                this.put(SEPAException.Fehler.BLZ_UNGUELTIG, i18n.tr("BLZ unbekannt"));
                this.put(SEPAException.Fehler.KONTO_LEER, i18n.tr("Keine Kontonummer angegeben"));
                this.put(SEPAException.Fehler.KONTO_UNGUELTIGE_LAENGE, i18n.tr("L\u00e4nge der Kontonummer ung\u00fcltig"));
                this.put(SEPAException.Fehler.KONTO_PRUEFZIFFER_FALSCH, i18n.tr("Pr\u00fcfziffer der Kontonummer falsch"));
                this.put(SEPAException.Fehler.KONTO_PRUEFZIFFERNREGEL_NICHT_IMPLEMENTIERT, i18n.tr("Pr\u00fcfziffern-Verfahren der Kontonummer unbekannt"));
                this.put(SEPAException.Fehler.IBANREGEL_NICHT_IMPLEMENTIERT, i18n.tr("IBAN-Regel unbekannt"));
                this.put(SEPAException.Fehler.UNGUELTIGES_LAND, i18n.tr("Land unbekannt"));
            }
        };
        ignoredErrors = new ArrayList<SEPAException.Fehler>(){
            {
                this.add(SEPAException.Fehler.UNGUELTIGES_LAND);
            }
        };
    }

    public static final String clean(String text, String validChars) {
        char[] chars;
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        char[] cArray = chars = text.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (validChars.contains(Character.toString(c))) {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static final String replace(String text, String[][] replacements) {
        if (text == null || text.length() == 0) {
            return text;
        }
        return StringUtils.replaceEach((String)text, (String[])replacements[0], (String[])replacements[1]);
    }

    public static final void checkChars(String chars, String validChars) throws ApplicationException {
        if (chars == null || chars.length() == 0) {
            return;
        }
        char[] c = chars.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (validChars.indexOf(c[i]) == -1) {
                throw new ApplicationException(i18n.tr("Das Zeichen \"{0}\" darf in \"{1}\" nicht verwendet werden", new String[]{"" + c[i], chars}));
            }
            ++i;
        }
    }

    public static final void checkLength(String chars, int maxLength) throws ApplicationException {
        if (chars == null || chars.length() == 0) {
            return;
        }
        if (chars.length() > maxLength) {
            throw new ApplicationException(i18n.tr("Der Text \"{0}\" ist zu lang. Bitte geben Sie maximal {1} Zeichen ein", new String[]{chars, "" + maxLength}));
        }
    }

    public static final String group(String s, int len, String sep) {
        if (s == null) {
            return "";
        }
        if (sep == null) {
            sep = " ";
        }
        return s.replaceAll("(.{" + len + "})", "$0" + sep).trim();
    }

    public static final String formatIban(String s) {
        if (s == null) {
            return "";
        }
        try {
            HBCIProperties.checkChars(s, String.valueOf(HBCI_IBAN_VALIDCHARS) + " ");
            s = s.replaceAll(" ", "");
            return HBCIProperties.group(s, 4, " ").toUpperCase();
        }
        catch (ApplicationException ae) {
            return s;
        }
    }

    public static final String getNameForBank(String bic) {
        if ((bic = StringUtils.trimToNull((String)bic)) == null) {
            return null;
        }
        Bank bank = null;
        bank = bic.length() == HBCI_BLZ_LENGTH ? Banken.getBankByBLZ((String)bic) : Banken.getBankByBIC((String)bic);
        if (bank == null) {
            return null;
        }
        return StringUtils.abbreviateMiddle((String)bank.getBezeichnung(), (String)"...", (int)24);
    }

    public static BankInfo getBankInfo(String blz) {
        return HBCIUtils.getBankInfo((String)blz);
    }

    public static final boolean checkAccountCRC(String blz, String kontonummer) {
        if (!Settings.getKontoCheck()) {
            return true;
        }
        if (blz == null || blz.length() == 0 || blz.length() != HBCI_BLZ_LENGTH) {
            Logger.warn((String)("blz [" + blz + "] not defined or out of range, skip crc check"));
            return true;
        }
        if (kontonummer == null || kontonummer.length() == 0 || kontonummer.length() > HBCI_KTO_MAXLENGTH_HARD) {
            Logger.warn((String)("account number [" + kontonummer + "] not defined out of range, skip crc check"));
            return true;
        }
        int i = 0;
        while (i < 2) {
            block15: {
                block14: {
                    block13: {
                        if (HBCIUtils.canCheckAccountCRC((String)blz)) break block13;
                        return true;
                    }
                    if (!HBCIUtils.checkAccountCRC((String)blz, (String)kontonummer)) break block14;
                    return true;
                }
                if (Settings.getKontoCheckExcludeAddressbook()) break block15;
                return false;
            }
            try {
                HBCIDBService db = Settings.getDBService();
                HibiscusAddress address = (HibiscusAddress)db.createObject(HibiscusAddress.class, null);
                address.setBlz(blz);
                address.setKontonummer(kontonummer);
                AddressbookService service = (AddressbookService)Application.getServiceFactory().lookup(HBCI.class, "addressbook");
                return service.contains(address) != null;
            }
            catch (Exception e) {
                if (i == 0) {
                    try {
                        Logger.warn((String)"HBCI4Java subsystem seems to be not initialized for this thread group, adding thread group");
                        HBCI plugin = (HBCI)Application.getPluginLoader().getPlugin(HBCI.class);
                        HBCIUtils.initThread((Properties)plugin.getHBCIPropetries(), (HBCICallback)plugin.getHBCICallback());
                    }
                    catch (Exception e2) {
                        Logger.error((String)"unable to initialize HBCI4Java subsystem", (Throwable)e2);
                    }
                } else {
                    Logger.error((String)"unable to verify account crc number", (Throwable)e);
                }
                ++i;
            }
        }
        Logger.error((String)"unable to verify account crc number");
        return true;
    }

    @Deprecated
    public static final boolean checkIBANCRC(String iban) {
        try {
            HBCIProperties.checkIBAN(iban);
            return true;
        }
        catch (ApplicationException ae) {
            return false;
        }
    }

    public static final String checkBIC(String bic) throws ApplicationException {
        HBCIProperties.checkChars(bic, HBCI_BIC_VALIDCHARS);
        int len = bic.length();
        if (len != HBCI_BIC_MAXLENGTH && len != 8) {
            throw new ApplicationException(i18n.tr("Bitte pr\u00fcfen Sie die L\u00e4nge der BIC. Muss entweder 8 oder 11 Zeichen lang sein."));
        }
        if (len == 8) {
            bic = String.valueOf(bic) + "XXX";
        }
        return bic;
    }

    public static final boolean checkCreditorIdCRC(String creditorId) {
        block6: {
            if (creditorId != null && creditorId.length() != 0 && creditorId.length() <= HBCI_SEPA_CREDITORID_MAXLENGTH) break block6;
            return false;
        }
        try {
            return HBCIUtils.checkCredtitorIdCRC((String)creditorId);
        }
        catch (NumberFormatException nfe) {
            Logger.warn((String)("invalid creditor-id: " + nfe.getMessage()));
            return false;
        }
        catch (Exception e) {
            try {
                Logger.warn((String)"HBCI4Java subsystem seems to be not initialized for this thread group, adding thread group");
                HBCI plugin = (HBCI)Application.getPluginLoader().getPlugin(HBCI.class);
                HBCIUtils.initThread((Properties)plugin.getHBCIPropetries(), (HBCICallback)plugin.getHBCICallback());
                return HBCIUtils.checkCredtitorIdCRC((String)creditorId);
            }
            catch (Exception e2) {
                Logger.error((String)"unable to verify creditor id crc number", (Throwable)e2);
                return true;
            }
        }
    }

    public static final IBAN getIBAN(String iban) throws ApplicationException {
        if (StringUtils.trimToNull((String)iban) == null) {
            return null;
        }
        if ((iban = StringUtils.deleteWhitespace((String)iban)) == null || iban.length() == 0) {
            return null;
        }
        if (!Settings.getKontoCheck()) {
            return null;
        }
        try {
            return new IBAN(iban);
        }
        catch (SEPAException se) {
            SEPAException.Fehler f = se.getFehler();
            if (f != null && ignoredErrors.contains(f)) {
                Logger.warn((String)("unable to verify IBAN, got error " + f + ", will be tolerated"));
                return null;
            }
            throw new ApplicationException(se.getMessage());
        }
    }

    public static final void checkIBAN(String iban) throws ApplicationException {
        if (StringUtils.trimToNull((String)iban) == null) {
            throw new ApplicationException(i18n.tr("Bitte geben Sie eine IBAN ein"));
        }
        if ((iban = StringUtils.deleteWhitespace((String)iban)) == null || iban.length() == 0) {
            throw new ApplicationException(i18n.tr("Bitte geben Sie eine IBAN ein"));
        }
        if (!Settings.getKontoCheck()) {
            return;
        }
        if (Settings.getKontoCheckExcludeAddressbook()) {
            try {
                HBCIDBService db = Settings.getDBService();
                HibiscusAddress address = (HibiscusAddress)db.createObject(HibiscusAddress.class, null);
                address.setIban(iban);
                AddressbookService service = (AddressbookService)Application.getServiceFactory().lookup(HBCI.class, "addressbook");
                if (service.contains(address) != null) {
                    return;
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to validate iban", (Throwable)e);
            }
        }
        try {
            IBAN i = new IBAN(iban);
            IBANCode code = i.getCode();
            if (code == null || code == IBANCode.GUELTIG) {
                return;
            }
            if (code == IBANCode.KONTONUMMERERSETZT || code == IBANCode.GEMELDETEBLZZURLOESCHUNGVORGEMERKT || code == IBANCode.PRUEFZIFFERNMETHODEFEHLT) {
                return;
            }
            throw new ApplicationException(code.getMessage());
        }
        catch (SEPAException e) {
            String msg;
            SEPAException.Fehler f = e.getFehler();
            if (f != null && (msg = obantooCodes.get(f)) != null) {
                throw new ApplicationException(i18n.tr("IBAN \"{0}\": {1}", new String[]{iban, msg}));
            }
            msg = e.getMessage();
            if (msg != null) {
                throw new ApplicationException(i18n.tr("IBAN \"{0}\": {1}", new String[]{iban, msg}));
            }
            throw new ApplicationException(i18n.tr("IBAN ung\u00fcltig: \"{0}\"", iban));
        }
    }

    public static final IBAN getIBAN(String blz, String konto) throws ApplicationException {
        try {
            IBAN iban = new IBAN(konto, blz, "DE");
            IBANCode code = iban.getCode();
            if (code == null || code == IBANCode.GUELTIG) {
                return iban;
            }
            if (code == IBANCode.KONTONUMMERERSETZT || code == IBANCode.GEMELDETEBLZZURLOESCHUNGVORGEMERKT || code == IBANCode.PRUEFZIFFERNMETHODEFEHLT) {
                return iban;
            }
            throw new ApplicationException(code.getMessage());
        }
        catch (SEPAException e) {
            String msg;
            SEPAException.Fehler f = e.getFehler();
            if (f != null && (msg = obantooCodes.get(f)) != null) {
                throw new ApplicationException(msg);
            }
            msg = e.getMessage();
            if (msg != null) {
                throw new ApplicationException(msg);
            }
            Logger.error((String)"unable to generate IBAN", (Throwable)e);
            throw new ApplicationException(i18n.tr("IBAN konnte nicht ermittelt werden"));
        }
        catch (Throwable e2) {
            Logger.error((String)"unable to generate IBAN", (Throwable)e2);
            throw new ApplicationException(i18n.tr("IBAN konnte nicht ermittelt werden"));
        }
    }

    public static Throwable getCause(Throwable t) {
        return HBCIProperties.getCause(t, null);
    }

    public static Throwable getCause(Throwable t, Class<? extends Throwable> c) {
        Throwable cause = t;
        int i = 0;
        while (i < 20) {
            if (c != null && c.equals(cause.getClass())) {
                return cause;
            }
            Throwable current = cause.getCause();
            if (current == null || current == cause) break;
            cause = current;
            ++i;
        }
        return c != null ? null : cause;
    }

    public static Date startOfDay(Date date) {
        return DateUtil.startOfDay((Date)date);
    }

    public static Date endOfDay(Date date) {
        return DateUtil.endOfDay((Date)date);
    }

    public static Set<String> getCustomerIDs(HBCIPassport passport) {
        Konto[] accounts = passport.getAccounts();
        HashSet<String> set = new HashSet<String>();
        set.add(passport.getCustomerId());
        if (accounts == null || accounts.length == 0) {
            set.add(passport.getUserId());
            return set;
        }
        int i = 0;
        while (i < accounts.length) {
            String value = accounts[i].customerid;
            if (value != null) {
                set.add(value);
            }
            ++i;
        }
        return set;
    }

    private HBCIProperties() {
    }
}

