/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.KontoauszugInterval;
import de.willuhn.jameica.system.Application;
import java.io.File;
import java.rmi.RemoteException;

public enum MetaKey {
    REMINDER_UUID("reminder.uuid", null, null),
    REMINDER_TEMPLATE("reminder.template", null, null),
    REMINDER_CREATOR("reminder.creator", null, "unknown"),
    ADDRESS_ID("address.id", null, null),
    SEPA_MANDATE_ID("sepa.mandateid", "SEPA-Mandatsreferenz", null),
    SEPA_MANDATE_SIGDATE("sepa.sigdate", "Signatur-Datum des Mandats", null),
    SEPA_SEQUENCE_CODE("sepa.sequencetype", "Signatur-Datum des Mandats", null),
    SEPA_CREDITOR_ID("sepa.creditor.id", "Gl\u00e4ubiger-Identifikation", null),
    SEPA_BATCHBOOK("sepa.batchbook", "Ums\u00e4tze dieses Sammelauftrages", null),
    KONTOAUSZUG_IGNORE_FORMAT("kontoauszug.ignoreformat", "Auch abrufen, wenn Kontoauszug nicht unterst\u00fctzt oder kein PDF-Format angeboten wird", "false"),
    KONTOAUSZUG_MARK_READ("kontoauszug.markread", "Automatisch als gelesen markieren", "false"),
    KONTOAUSZUG_SEND_RECEIPT("kontoauszug.send.receipt", "Automatisch Empfangsquittung an Bank senden", "true"),
    KONTOAUSZUG_INTERVAL("kontoauszug.interval", "Intervall", KontoauszugInterval.DEFAULT.getId()),
    KONTOAUSZUG_INTERVAL_LAST("kontoauszug.interval.last", "Datum des letzten Abrufs", null),
    KONTOAUSZUG_STORE_MESSAGING("kontoauszug.store.messaging", "Kontoausz\u00fcge per Jameica Messaging speichern", "false"),
    KONTOAUSZUG_STORE_PATH("kontoauszug.store.path", "Kontoausz\u00fcge speichern in", String.valueOf(Application.getPluginLoader().getPlugin(HBCI.class).getResources().getWorkPath()) + File.separator + "kontoauszuege"),
    KONTOAUSZUG_TEMPLATE_PATH("kontoauszug.template.path", "Vorlage f\u00fcr Unterordner", "${iban}" + File.separator + "${jahr}"),
    KONTOAUSZUG_TEMPLATE_NAME("kontoauszug.template.name", "Vorlage f\u00fcr Dateinamen", "${jahr}-${nummer}"),
    UMSATZ_CAMT("umsatz.camt", "CAMT-Format f\u00fcr Umsatz-Abruf verwenden", null),
    TAN_CANCEL("sync.tan-cancel", "TAN-Eingabe abgebrochen", null);

    private String name = null;
    private String description = null;
    private String defaultValue = null;

    private MetaKey(String name, String description, String defaultValue) {
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public String get(HibiscusDBObject o) throws RemoteException {
        return this.get(o, null);
    }

    public void set(HibiscusDBObject o, String value) throws RemoteException {
        this.set(o, null, value);
    }

    public String get(HibiscusDBObject o, String suffix) throws RemoteException {
        String key = this.name;
        if (suffix != null) {
            key = String.valueOf(key) + "." + suffix;
        }
        return o.getMeta(key, this.defaultValue);
    }

    public void set(HibiscusDBObject o, String suffix, String value) throws RemoteException {
        String key = this.name;
        if (suffix != null) {
            key = String.valueOf(key) + "." + suffix;
        }
        o.setMeta(key, value);
    }
}

