/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.passport.Passport;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ClassFinder;
import java.util.Enumeration;
import java.util.Hashtable;

public class PassportRegistry {
    private static Hashtable passportsByName = null;
    private static Hashtable passportsByClass = null;

    public static synchronized void init() {
        if (passportsByClass != null || passportsByName != null) {
            return;
        }
        passportsByClass = new Hashtable();
        passportsByName = new Hashtable();
        try {
            Class[] found;
            Logger.info((String)"searching for available passports");
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            ClassFinder finder = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader().getClassFinder();
            Class[] classArray = found = finder.findImplementors(Passport.class);
            int n = found.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                try {
                    Passport p = (Passport)service.get(c);
                    Application.getCallback().getStartupMonitor().setStatusText("init passport " + p.getName());
                    passportsByName.put(p.getName(), c);
                    passportsByClass.put(c.getName(), c);
                    Logger.info((String)("  " + p.getName() + " [" + p.getClass().getName() + "]"));
                }
                catch (Exception e) {
                    Logger.error((String)"failed, skipping passport", (Throwable)e);
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException cn) {
            Logger.warn((String)"no passports found");
        }
        catch (Throwable t) {
            Logger.error((String)"error while searching for passports", (Throwable)t);
        }
    }

    private static Passport load(Class c) throws Exception {
        if (c == null) {
            return null;
        }
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        Passport p = (Passport)service.get(c);
        Logger.debug((String)("[" + c.getName() + "][" + p.getName() + "] instantiated successfully"));
        return p;
    }

    public static Passport findByName(String name) throws Exception {
        if (name == null) {
            return null;
        }
        PassportRegistry.init();
        return PassportRegistry.load((Class)passportsByName.get(name));
    }

    public static Passport findByClass(String classname) throws Exception {
        if (classname == null) {
            return null;
        }
        PassportRegistry.init();
        return PassportRegistry.load((Class)passportsByClass.get(classname));
    }

    public static Passport[] getPassports() throws Exception {
        PassportRegistry.init();
        Enumeration e = passportsByName.elements();
        Passport[] passports = new Passport[passportsByName.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            passports[i++] = PassportRegistry.load((Class)e.nextElement());
        }
        return passports;
    }
}

