/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.security.Wallet;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public class Settings {
    private static de.willuhn.jameica.system.Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private static HBCIDBService db = null;
    private static String workPath = null;
    private static String libPath = null;
    private static Wallet wallet = null;
    private static Color buchungSollForeground = null;
    private static Color buchungHabenForeground = null;

    public static HBCIDBService getDBService() throws RemoteException {
        if (db != null) {
            return db;
        }
        try {
            db = (HBCIDBService)Application.getServiceFactory().lookup(HBCI.class, "database");
            return db;
        }
        catch (ConnectException ce) {
            I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
            String host = Application.getServiceFactory().getLookupHost(HBCI.class, "database");
            int port = Application.getServiceFactory().getLookupPort(HBCI.class, "database");
            String msg = i18n.tr("Hibiscus-Server \"{0}\" nicht erreichbar", String.valueOf(host) + ":" + port);
            try {
                Application.getCallback().notifyUser(msg);
                throw new RemoteException(msg);
            }
            catch (Exception e) {
                Logger.error((String)"error while notifying user", (Throwable)e);
                throw new RemoteException(msg);
            }
        }
        catch (ApplicationException ae) {
            throw new RemoteException(ae.getMessage());
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RemoteException("unable to open/create database", e);
        }
    }

    public static Color getBuchungSollForeground() {
        if (buchungSollForeground != null) {
            return buchungSollForeground;
        }
        buchungSollForeground = new Color((Device)GUI.getDisplay(), settings.getRGB("buchung.soll.fg", new RGB(226, 102, 38)));
        return buchungSollForeground;
    }

    public static Color getBuchungHabenForeground() {
        if (buchungHabenForeground != null) {
            return buchungHabenForeground;
        }
        buchungHabenForeground = new Color((Device)GUI.getDisplay(), settings.getRGB("buchung.haben.fg", new RGB(29, 158, 33)));
        return buchungHabenForeground;
    }

    public static void setBuchungSollForeground(RGB rgb) {
        settings.setAttribute("buchung.soll.fg", rgb);
        buchungSollForeground = null;
    }

    public static void setBuchungHabenForeground(RGB rgb) {
        settings.setAttribute("buchung.haben.fg", rgb);
        buchungHabenForeground = null;
    }

    public static String getLibPath() {
        if (libPath != null) {
            return libPath;
        }
        libPath = String.valueOf(Application.getPluginLoader().getPlugin(HBCI.class).getManifest().getPluginDir()) + "/lib";
        try {
            libPath = new File(libPath).getCanonicalPath();
        }
        catch (Exception e) {
            Logger.error((String)"error while determining canonical path", (Throwable)e);
        }
        return libPath;
    }

    public static String getWorkPath() {
        if (workPath != null) {
            return workPath;
        }
        workPath = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getWorkPath();
        return workPath;
    }

    public static void setCachePin(boolean cachePin) {
        settings.setAttribute("cachepin", cachePin);
    }

    public static boolean getCachePin() {
        return settings.getBoolean("cachepin", true);
    }

    public static void setStorePin(boolean storePin) {
        settings.setAttribute("storepin", Settings.getCachePin() && storePin);
    }

    public static boolean getStorePin() {
        return Application.getStartupParams().getPassword() == null && Settings.getCachePin() && settings.getBoolean("storepin", false);
    }

    public static boolean getDecimalGrouping() {
        return settings.getBoolean("decimalgrouping", false);
    }

    public static void setDecimalGrouping(boolean grouping) {
        settings.setAttribute("decimalgrouping", grouping);
        HBCI.DECIMALFORMAT.setGroupingUsed(grouping);
    }

    public static boolean getBoldValues() {
        return settings.getBoolean("boldvalues", true);
    }

    public static void setBoldValues(boolean bold) {
        settings.setAttribute("boldvalues", bold);
    }

    public static boolean getColorValues() {
        return settings.getBoolean("colorvalues", true);
    }

    public static void setColorValues(boolean color) {
        settings.setAttribute("colorvalues", color);
    }

    public static void setOnlineMode(boolean online) {
        settings.setAttribute("online", online);
    }

    public static boolean getKontoCheck() {
        return settings.getBoolean("kontocheck", true);
    }

    public static void setKontoCheck(boolean check) {
        settings.setAttribute("kontocheck", check);
    }

    public static boolean getKontoCheckExcludeAddressbook() {
        return settings.getBoolean("kontocheck.addressbook.exclude", false);
    }

    public static void setKontoCheckExcludeAddressbook(boolean check) {
        settings.setAttribute("kontocheck.addressbook.exclude", check);
    }

    public static boolean getStoreUnreadFlag() {
        return settings.getBoolean("unread.store", true);
    }

    public static void setStoreUnreadFlag(boolean store) {
        settings.setAttribute("unread.store", store);
    }

    public static boolean getMarkReadOnExit() {
        return settings.getBoolean("unread.markreadonexit", true);
    }

    public static void setMarkReadOnExit(boolean b) {
        settings.setAttribute("unread.markreadonexit", b);
    }

    public static boolean getOnlineMode() {
        return settings.getBoolean("online", true);
    }

    public static double getUeberweisungLimit() {
        return settings.getDouble("ueberweisunglimit", 10000.0);
    }

    public static void setUeberweisungLimit(double limit) {
        settings.setAttribute("ueberweisunglimit", limit);
    }

    public static boolean getSaldoInChecksum() {
        return settings.getBoolean("umsatz.checksum.saldo", false);
    }

    public static Wallet getWallet() throws Exception {
        if (wallet == null) {
            wallet = new Wallet(HBCI.class);
        }
        return wallet;
    }

    public static boolean isFirstStart() {
        if (!Application.getPluginLoader().getManifest(HBCI.class).isInstalled()) {
            return true;
        }
        try {
            DBIterator konten = Settings.getDBService().createList(Konto.class);
            return konten.size() == 0;
        }
        catch (Exception e) {
            Logger.error((String)"unable to load konto list", (Throwable)e);
            return true;
        }
    }

    public static String getServerURL() {
        return settings.getString("ServerURL", "https://fibu.myema.de/fibu-api/api/v1/");
    }

    public static void setServerURL(String serverURL) {
        settings.setAttribute("ServerURL", serverURL.trim());
    }

    public static String getUserName() {
        return settings.getString("BenutzerName", "monika.musterfrau");
    }

    public static void setUserName(String userName) {
        settings.setAttribute("BenutzerName", userName.trim());
    }

    public static String getPassword() {
        return settings.getString("Kennwort", "Geheim!");
    }

    public static void setPassword(String password) {
        settings.setAttribute("Kennwort", password.trim());
    }

    public static String getBezirksID() {
        return settings.getString("BezirksID", "30");
    }

    public static void setBezirksID(String bezirksID) {
        settings.setAttribute("BezirksID", bezirksID.trim());
    }

    public static String getBuchungsJahr() {
        return settings.getString("BuchungsJahr", "2022");
    }

    public static void setBuchungsJahr(String bookingYear) {
        settings.setAttribute("BuchungsJahr", bookingYear.trim());
    }
}

