/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;

public class SynchronizeOptions
implements Serializable {
    private String id = null;
    private boolean offline = false;
    private boolean disabled = false;
    private static final de.willuhn.jameica.system.Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();

    public static List<Konto> getSynchronizeKonten() {
        LinkedList<Konto> l = new LinkedList<Konto>();
        try {
            DBIterator konten = Settings.getDBService().createList(Konto.class);
            konten.setOrder("order by blz,bic,passport_class,bezeichnung");
            while (konten.hasNext()) {
                SynchronizeOptions o;
                Konto k = (Konto)konten.next();
                if (k.hasFlag(1) || !(o = new SynchronizeOptions(k)).getSynchronize()) continue;
                l.add(k);
            }
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to load konto list", (Throwable)re);
        }
        return l;
    }

    public SynchronizeOptions(Konto k) throws RemoteException {
        this.offline = k.hasFlag(2);
        this.disabled = k.hasFlag(1);
        this.id = k.getID();
    }

    public boolean getSynchronize() {
        return this.getSyncSaldo() || this.getSyncKontoauszuege() || this.getSyncKontoauszuegePdf() || this.getSyncSepaDauerauftraege() || this.getSyncAuslandsUeberweisungen() || this.getSyncSepaLastschriften();
    }

    public void setAll(boolean status) {
        this.setSyncSaldo(status);
        this.setSyncKontoauszuege(status);
        this.setSyncKontoauszuegePdf(status);
        this.setSyncSepaDauerauftraege(status);
        this.setSyncAuslandsUeberweisungen(status);
        this.setSyncSepaLastschriften(status);
    }

    public boolean getSyncSaldo() {
        return !this.disabled && settings.getBoolean("sync.konto." + this.id + ".saldo", settings.getBoolean("sync.konto.default.saldo", true));
    }

    public boolean getSyncMessages() {
        return !this.disabled && !this.offline && settings.getBoolean("sync.konto." + this.id + ".messages", settings.getBoolean("sync.konto.default.messages", true));
    }

    public boolean getSyncKontoauszuege() {
        return !this.disabled && settings.getBoolean("sync.konto." + this.id + ".kontoauszug", settings.getBoolean("sync.konto.default.kontoauszug", true));
    }

    public boolean getSyncKontoauszuegePdf() {
        return !this.disabled && settings.getBoolean("sync.konto." + this.id + ".kontoauszugpdf", settings.getBoolean("sync.konto.default.kontoauszugpdf", false));
    }

    public boolean getSyncSepaDauerauftraege() {
        return !this.disabled && !this.offline && settings.getBoolean("sync.konto." + this.id + ".sepadauer", settings.getBoolean("sync.konto.default.sepadauer", false));
    }

    public boolean getSyncAuslandsUeberweisungen() {
        return !this.disabled && !this.offline && settings.getBoolean("sync.konto." + this.id + ".uebforeign", settings.getBoolean("sync.konto.default.uebforeign", false));
    }

    public boolean getSyncSepaLastschriften() {
        return !this.disabled && !this.offline && settings.getBoolean("sync.konto." + this.id + ".sepalast", settings.getBoolean("sync.konto.default.sepalast", false));
    }

    public boolean getSyncOffline() {
        return !this.disabled && settings.getBoolean("sync.konto." + this.id + ".offline", true);
    }

    public boolean getAutoSaldo() {
        return !this.disabled && this.offline && settings.getBoolean("sync.konto." + this.id + ".autosaldo", true);
    }

    public void setAutoSaldo(boolean b) {
        settings.setAttribute("sync.konto." + this.id + ".autosaldo", b);
    }

    public void setSyncMessages(boolean b) {
        settings.setAttribute("sync.konto." + this.id + ".messages", b);
    }

    public void setSyncKontoauszuege(boolean b) {
        settings.setAttribute("sync.konto." + this.id + ".kontoauszug", b);
    }

    public void setSyncKontoauszuegePdf(boolean b) {
        settings.setAttribute("sync.konto." + this.id + ".kontoauszugpdf", b);
    }

    public void setSyncSaldo(boolean b) {
        settings.setAttribute("sync.konto." + this.id + ".saldo", b);
    }

    public void setSyncSepaDauerauftraege(boolean b) {
        settings.setAttribute("sync.konto." + this.id + ".sepadauer", b);
    }

    public void setSyncAuslandsUeberweisungen(boolean b) {
        settings.setAttribute("sync.konto." + this.id + ".uebforeign", b);
    }

    public void setSyncSepaLastschriften(boolean b) {
        settings.setAttribute("sync.konto." + this.id + ".sepalast", b);
    }

    public void setSyncOffline(boolean b) {
        settings.setAttribute("sync.konto." + this.id + ".offline", b);
    }
}

