/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.List;

public class TextSchluessel {
    private static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    public static final String TS_ABBUCHUNG = "04";
    public static final String TS_EINZUG = "05";
    public static final String TS_UEB = "51";
    public static final String TS_DAUER = "52";
    public static final String TS_LOHN = "53";
    public static final String TS_VL = "54";
    public static final String TS_RUECKUEB = "59";
    public static final String TS_BZU = "67";
    public static final String TS_SPENDE = "69";
    public static final String[] SET_DAUER = new String[]{"52", "53", "54"};
    public static final String[] SET_SAMMELLAST = new String[]{"05", "04"};
    public static final String[] SET_LAST = new String[]{"05", "04"};
    public static final String[] SET_SAMMELUEB = new String[]{"51", "53", "54"};
    public static final String[] SET_UEB = new String[]{"51", "53", "54", "59", "67"};
    private static final List<TextSchluessel> list = new ArrayList<TextSchluessel>();
    private String code = null;
    private String name = null;

    static {
        list.add(new TextSchluessel(TS_ABBUCHUNG, i18n.tr("Abbuchungsverfahren")));
        list.add(new TextSchluessel(TS_EINZUG, i18n.tr("Einzugserm\u00e4chtigung")));
        list.add(new TextSchluessel(TS_DAUER, i18n.tr("Dauerauftrag")));
        list.add(new TextSchluessel(TS_UEB, i18n.tr("\u00dcberweisung")));
        list.add(new TextSchluessel(TS_LOHN, i18n.tr("\u00dcberweisung Lohn/Gehalt/Rente")));
        list.add(new TextSchluessel(TS_VL, i18n.tr("Verm\u00f6genswirksame Leistungen")));
        list.add(new TextSchluessel(TS_RUECKUEB, i18n.tr("R\u00fcck\u00fcberweisung")));
        list.add(new TextSchluessel(TS_BZU, i18n.tr("BZ\u00dc-\u00dcberweisung")));
        list.add(new TextSchluessel(TS_SPENDE, i18n.tr("Spende")));
    }

    public static TextSchluessel[] get(String[] codes) {
        if (codes == null || codes.length == 0) {
            return list.toArray(new TextSchluessel[0]);
        }
        ArrayList<TextSchluessel> l = new ArrayList<TextSchluessel>();
        int i = 0;
        while (i < codes.length) {
            int k = 0;
            while (k < list.size()) {
                TextSchluessel ts = list.get(k);
                String code = ts.getCode();
                if (code.equals(codes[i])) {
                    l.add(ts);
                }
                ++k;
            }
            ++i;
        }
        return l.toArray(new TextSchluessel[0]);
    }

    public static TextSchluessel get(String code) {
        if (code == null || code.length() == 0) {
            return null;
        }
        int i = 0;
        while (i < list.size()) {
            TextSchluessel ts = list.get(i);
            if (ts.getCode().equals(code)) {
                return ts;
            }
            ++i;
        }
        return null;
    }

    private TextSchluessel(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return i18n.tr("[{0}] {1}", new String[]{this.code, this.name});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof TextSchluessel)) {
            return false;
        }
        return this.code.equals(((TextSchluessel)other).getCode());
    }
}

