/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.accounts;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.accounts.AccountProvider;
import de.willuhn.jameica.hbci.accounts.hbci.HBCIAccountProvider;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class AccountService {
    private List<AccountProvider> providers = null;
    private static final Class<? extends HBCIAccountProvider> PRIMARY = HBCIAccountProvider.class;

    public synchronized List<AccountProvider> getProviders() {
        if (this.providers != null) {
            return this.providers;
        }
        this.providers = new LinkedList<AccountProvider>();
        try {
            Class[] found;
            Logger.info((String)"loading account providers");
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            Class[] classArray = found = Application.getPluginLoader().getPlugin(HBCI.class).getManifest().getClassLoader().getClassFinder().findImplementors(AccountProvider.class);
            int n = found.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                try {
                    Logger.debug((String)("  " + c.getName()));
                    this.providers.add((AccountProvider)service.get(c));
                }
                catch (Exception e) {
                    Logger.error((String)("unable to load account provider " + c.getName() + ", skipping"), (Throwable)e);
                }
                ++n2;
            }
            Collections.sort(this.providers, new Comparator<AccountProvider>(){

                @Override
                public int compare(AccountProvider o1, AccountProvider o2) {
                    if (PRIMARY.isInstance(o1)) {
                        return -1;
                    }
                    if (PRIMARY.isInstance(o2)) {
                        return 1;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        catch (ClassNotFoundException e) {
            Logger.warn((String)"no account providers found");
        }
        catch (Exception e) {
            Logger.error((String)"error while searching for account providers", (Throwable)e);
        }
        return this.providers;
    }
}

