/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.accounts.hbci;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.gui.parts.InfoPanel;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.accounts.AccountProvider;
import de.willuhn.jameica.hbci.accounts.hbci.HBCIVariant;
import de.willuhn.jameica.hbci.accounts.hbci.HBCIVariantPinTan;
import de.willuhn.jameica.hbci.accounts.hbci.action.HBCIAccountNew;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class HBCIAccountProvider
implements AccountProvider {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final Class<? extends HBCIVariant> PRIMARY = HBCIVariantPinTan.class;
    private List<HBCIVariant> variants = null;

    @Override
    public String getName() {
        return i18n.tr("FinTS/HBCI-Bankzugang");
    }

    @Override
    public InfoPanel getInfo() {
        InfoPanel info = new InfoPanel();
        info.setTitle(this.getName());
        info.setText(i18n.tr("Verwenden Sie diese Option f\u00fcr die Anlage von Bankzug\u00e4ngen mit PIN/TAN-Verfahren, Schl\u00fcsseldatei oder Chipkarte."));
        info.setComment(i18n.tr("HBCI/FinTS ist der in Hibiscus haupts\u00e4chlich verwendete Bankzugang."));
        info.setUrl("http://www.willuhn.de/wiki/doku.php?id=support:list:banken");
        info.setIcon("hibiscus-large.png");
        return info;
    }

    public synchronized List<HBCIVariant> getVariants() {
        if (this.variants != null) {
            return this.variants;
        }
        this.variants = new LinkedList<HBCIVariant>();
        try {
            Class[] found;
            Logger.info((String)"loading hbci variants");
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            Class[] classArray = found = Application.getPluginLoader().getPlugin(HBCI.class).getManifest().getClassLoader().getClassFinder().findImplementors(HBCIVariant.class);
            int n = found.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                try {
                    Logger.debug((String)("  " + c.getName()));
                    this.variants.add((HBCIVariant)service.get(c));
                }
                catch (Exception e) {
                    Logger.error((String)("unable to load hbci varian " + c.getName() + ", skipping"), (Throwable)e);
                }
                ++n2;
            }
            Collections.sort(this.variants, new Comparator<HBCIVariant>(){

                @Override
                public int compare(HBCIVariant o1, HBCIVariant o2) {
                    if (PRIMARY.isInstance(o1)) {
                        return -1;
                    }
                    if (PRIMARY.isInstance(o2)) {
                        return 1;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        catch (ClassNotFoundException e) {
            Logger.warn((String)"no hbci variants found");
        }
        catch (Exception e) {
            Logger.error((String)"error while searching for hbci variants", (Throwable)e);
        }
        return this.variants;
    }

    @Override
    public void create() throws ApplicationException {
        new HBCIAccountNew().handleAction(null);
    }
}

