/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.accounts.hbci.controller;

import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.InfoPanel;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.accounts.hbci.HBCIAccountProvider;
import de.willuhn.jameica.hbci.accounts.hbci.HBCIVariant;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.List;

public class HBCIAccountNewController
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private List<InfoPanel> variants;

    public HBCIAccountNewController(AbstractView view) {
        super(view);
    }

    public synchronized List<InfoPanel> getVariants() {
        if (this.variants != null) {
            return this.variants;
        }
        this.variants = new ArrayList<InfoPanel>();
        BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        final HBCIAccountProvider hbci = (HBCIAccountProvider)bs.get(HBCIAccountProvider.class);
        for (final HBCIVariant v : hbci.getVariants()) {
            InfoPanel p = v.getInfo();
            Button button = new Button(i18n.tr("Verfahren ausw\u00e4hlen..."), new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    Logger.info((String)("creating new account. type: " + hbci.getName() + ", variant: " + v.getName()));
                    v.create();
                }
            }, null, false, "go-next.png");
            p.addButton(button);
            this.variants.add(p);
        }
        return this.variants;
    }
}

