/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.accounts.hbci.controller;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.accounts.hbci.HBCIAccountPinTan;
import de.willuhn.jameica.hbci.accounts.hbci.action.HBCIVariantPinTanTest;
import de.willuhn.jameica.hbci.accounts.hbci.views.HBCIVariantPinTanStep2;
import de.willuhn.jameica.hbci.gui.input.BankInfoInput;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIUtils;

@Lifecycle(value=Lifecycle.Type.REQUEST)
public class HBCIVariantPinTanController
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private HBCIAccountPinTan account = new HBCIAccountPinTan();
    private BankInfoInput bank = null;
    private URLInput url = null;
    private TextInput customer = null;
    private TextInput username = null;
    private Button step1 = null;
    private Button step2 = null;
    private Listener step1Listener = new Step1Listener();
    private Listener step2Listener = new Step2Listener();

    public HBCIVariantPinTanController() {
        super(null);
    }

    public BankInfoInput getBank() {
        if (this.bank != null) {
            return this.bank;
        }
        this.bank = new BankInfoInput(this.account.getBlz());
        if (this.bank.getValue() == null) {
            this.bank.setValue(this.account.getBlz());
        }
        this.bank.addListener(new Listener(){

            public void handleEvent(Event event) {
                BankInfo info = (BankInfo)HBCIVariantPinTanController.this.bank.getValue();
                if (info != null) {
                    String bic = info.getBic();
                    if (bic != null && bic.length() > 0) {
                        HBCIVariantPinTanController.this.bank.setComment(i18n.tr("Bank gefunden, BIC: {0}", info.getBic()));
                    } else {
                        HBCIVariantPinTanController.this.bank.setComment(i18n.tr("Bank gefunden"));
                    }
                } else {
                    HBCIVariantPinTanController.this.bank.setComment("");
                    return;
                }
                HBCIVariantPinTanController.this.account.setBlz(info.getBlz());
                String url = info.getPinTanAddress();
                if (url != null && url.length() > 0) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Adresse des Bankservers gefunden"), 0));
                    HBCIVariantPinTanController.this.account.setUrl(url);
                    HBCIVariantPinTanController.this.getURL().setValue(url);
                } else {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Bitte geben Sie die Adresse des Bankservers manuell ein"), 2));
                }
            }
        });
        this.bank.addListener(this.step1Listener);
        this.bank.setComment("");
        this.bank.setMandatory(true);
        return this.bank;
    }

    public URLInput getURL() {
        if (this.url != null) {
            return this.url;
        }
        this.url = new URLInput(this.account.getUrl());
        this.url.addListener(this.step1Listener);
        this.url.setMandatory(true);
        return this.url;
    }

    public Listener getStep1Listener() {
        return this.step1Listener;
    }

    public Listener getStep2Listener() {
        return this.step2Listener;
    }

    public TextInput getCustomer() {
        if (this.customer != null) {
            return this.customer;
        }
        this.customer = new TextInput(null, 50);
        this.customer.setHint(i18n.tr("Kundenkennung (oft identisch mit Benutzerkennung)"));
        this.customer.setComment("");
        this.customer.addListener(this.step2Listener);
        return this.customer;
    }

    public TextInput getUsername() {
        if (this.username != null) {
            return this.username;
        }
        this.username = new TextInput(null, 50);
        this.username.setHint(i18n.tr("Benutzerkennung"));
        this.username.setComment(this.getBankText());
        this.username.setMandatory(true);
        this.username.addListener(this.step2Listener);
        this.username.focus();
        return this.username;
    }

    public Button getStep1Button() {
        if (this.step1 != null) {
            return this.step1;
        }
        this.step1 = new Button(i18n.tr("Weiter ..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                HBCIVariantPinTanController.this.bank = null;
                HBCIVariantPinTanController.this.url = null;
                HBCIVariantPinTanController.this.username = null;
                HBCIVariantPinTanController.this.customer = null;
                GUI.startView(HBCIVariantPinTanStep2.class, (Object)((Object)HBCIVariantPinTanController.this));
            }
        }, null, true, "go-next.png");
        this.step1.setEnabled(false);
        return this.step1;
    }

    public Button getStep2Button() {
        if (this.step2 != null) {
            return this.step2;
        }
        this.step2 = new Button(i18n.tr("Weiter ..."), (Action)new HBCIVariantPinTanTest(), (Object)this.account, true, "mail-send-receive.png");
        this.step2.setEnabled(false);
        return this.step2;
    }

    public String getBankText() {
        String blz = this.account.getBlz();
        if (blz == null || blz.trim().length() == 0) {
            return null;
        }
        List result = HBCIUtils.searchBankInfo((String)blz);
        if (result == null || result.size() == 0) {
            return i18n.tr("BLZ: {0}", blz);
        }
        return ((BankInfo)result.get(0)).getName();
    }

    private class Step1Listener
    implements Listener {
        private Step1Listener() {
        }

        public void handleEvent(Event event) {
            String url = (String)HBCIVariantPinTanController.this.getURL().getValue();
            boolean enabled = url != null && url.trim().length() > 0;
            HBCIVariantPinTanController.this.getStep1Button().setEnabled(enabled);
            if (enabled) {
                HBCIVariantPinTanController.this.account.setUrl(url);
                if (HBCIVariantPinTanController.this.account.getBlz() == null) {
                    HBCIVariantPinTanController.this.account.setBlz(HBCIVariantPinTanController.this.getBank().getText());
                }
            }
        }
    }

    private class Step2Listener
    implements Listener {
        private Step2Listener() {
        }

        public void handleEvent(Event event) {
            String s = (String)HBCIVariantPinTanController.this.getUsername().getValue();
            boolean enabled = s != null && s.trim().length() > 0;
            HBCIVariantPinTanController.this.getStep2Button().setEnabled(enabled);
            if (enabled) {
                HBCIVariantPinTanController.this.account.setUsername(s);
                String customer = (String)HBCIVariantPinTanController.this.getCustomer().getValue();
                HBCIVariantPinTanController.this.account.setCustomer(customer != null && customer.trim().length() > 0 ? customer : s);
            }
        }
    }

    private class URLInput
    extends TextInput {
        public URLInput(String url) {
            super(url);
            this.setHint(i18n.tr("Adresse des Bankservers"));
            this.setComment("");
            this.addListener(new Listener(){

                public void handleEvent(Event event) {
                    HBCIVariantPinTanController.this.getURL().setValue(HBCIVariantPinTanController.this.getURL().getValue());
                }
            });
        }

        public Object getValue() {
            String s = (String)super.getValue();
            if (s == null || s.length() == 0) {
                return null;
            }
            return this.cleanUrl(s);
        }

        public void setValue(Object value) {
            String s = this.cleanUrl((String)value);
            super.setValue((Object)s);
        }

        private String cleanUrl(String url) {
            if ((url = StringUtils.trimToEmpty((String)url)).length() == 0) {
                return url;
            }
            if (url.startsWith("https://")) {
                url = url.replaceFirst("https://", "");
            }
            url = url.replaceFirst(":[0-9]{1,5}/", "/");
            return url;
        }
    }
}

