/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.calendar;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.jameica.gui.calendar.AbstractAppointment;
import de.willuhn.jameica.gui.calendar.Appointment;
import de.willuhn.jameica.gui.calendar.AppointmentProvider;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.Open;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.hbci.schedule.Schedule;
import de.willuhn.jameica.hbci.schedule.ScheduleProvider;
import de.willuhn.jameica.hbci.schedule.ScheduleProviderFactory;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractAppointmentProvider<T extends HibiscusDBObject>
implements AppointmentProvider {
    static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private ScheduleProvider provider = null;

    public List<Appointment> getAppointments(Date from, Date to) {
        LinkedList<Appointment> result = new LinkedList<Appointment>();
        ScheduleProvider provider = this.getScheduleProvider();
        if (provider == null) {
            Logger.warn((String)("unable to determine schedule provider for " + this.getClass().getSimpleName()));
            return result;
        }
        List list = provider.getSchedules(null, from, to);
        for (Schedule schedule : list) {
            result.add((Appointment)this.createAppointment(schedule));
        }
        return result;
    }

    private ScheduleProvider getScheduleProvider() {
        if (this.provider == null) {
            this.provider = ScheduleProviderFactory.getScheduleProvider(BeanUtil.getType(this.getClass()));
        }
        return this.provider;
    }

    abstract AbstractHibiscusAppointment createAppointment(Schedule<T> var1);

    public String getName() {
        ScheduleProvider provider = this.getScheduleProvider();
        return provider != null ? provider.getName() : "<unknown provider>";
    }

    abstract class AbstractHibiscusAppointment
    extends AbstractAppointment {
        protected Schedule<T> schedule = null;

        public void execute() throws ApplicationException {
            new Open().handleAction(this.schedule.getContext());
        }

        protected AbstractHibiscusAppointment(Schedule<T> schedule) {
            this.schedule = schedule;
        }

        public Date getDate() {
            return this.schedule.getDate();
        }

        public RGB getColor() {
            if (this.schedule.isPlanned() || !this.hasAlarm()) {
                return Color.COMMENT.getSWTColor().getRGB();
            }
            return Settings.getBuchungSollForeground().getRGB();
        }

        public boolean hasAlarm() {
            if (this.schedule.isPlanned()) {
                return true;
            }
            try {
                Object t = this.schedule.getContext();
                if (t instanceof Terminable) {
                    return !((Terminable)t).ausgefuehrt();
                }
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to determine execution status", (Throwable)re);
            }
            return super.hasAlarm();
        }

        public String getUid() {
            try {
                Object t = this.schedule.getContext();
                return String.valueOf(t.getClass().getName()) + "." + t.getID();
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to create uid", (Throwable)re);
                return super.getUid();
            }
        }
    }
}

