/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.calendar;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.calendar.AbstractAppointmentProvider;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.schedule.Schedule;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;

public class AuslandsUeberweisungAppointmentProvider
extends AbstractAppointmentProvider<AuslandsUeberweisung> {
    @Override
    AbstractAppointmentProvider.AbstractHibiscusAppointment createAppointment(Schedule<AuslandsUeberweisung> schedule) {
        return new MyAppointment(schedule);
    }

    private class MyAppointment
    extends AbstractAppointmentProvider.AbstractHibiscusAppointment {
        private MyAppointment(Schedule<AuslandsUeberweisung> schedule) {
            super(schedule);
        }

        public String getDescription() {
            try {
                AuslandsUeberweisung t = (AuslandsUeberweisung)this.schedule.getContext();
                Konto k = t.getKonto();
                return i18n.tr("{0}SEPA-\u00dcberweisung: {1} {2} an {3} \u00fcberweisen\n\n{4}\n\nKonto: {5}", new String[]{this.schedule.isPlanned() ? String.valueOf(i18n.tr("Geplant")) + ":\n" : "", HBCI.DECIMALFORMAT.format(t.getBetrag()), k.getWaehrung(), t.getGegenkontoName(), VerwendungszweckUtil.toString(t, "\n"), k.getLongName()});
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to build description", (Throwable)re);
                return null;
            }
        }

        public String getName() {
            try {
                AuslandsUeberweisung t = (AuslandsUeberweisung)this.schedule.getContext();
                Konto k = t.getKonto();
                return i18n.tr("{0} {1} an {2}", new String[]{HBCI.DECIMALFORMAT.format(t.getBetrag()), k.getWaehrung(), t.getGegenkontoName()});
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to build name", (Throwable)re);
                return i18n.tr("SEPA-\u00dcberweisung");
            }
        }
    }
}

