/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.calendar;

import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.calendar.AbstractAppointmentProvider;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.schedule.Schedule;
import de.willuhn.jameica.hbci.server.TurnusHelper;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.graphics.RGB;

public class SepaDauerauftragAppointmentProvider
extends AbstractAppointmentProvider<SepaDauerauftrag> {
    @Override
    AbstractAppointmentProvider.AbstractHibiscusAppointment createAppointment(Schedule<SepaDauerauftrag> schedule) {
        return new MyAppointment(schedule);
    }

    private class MyAppointment
    extends AbstractAppointmentProvider.AbstractHibiscusAppointment {
        private MyAppointment(Schedule<SepaDauerauftrag> schedule) {
            super(schedule);
        }

        public String getDescription() {
            try {
                SepaDauerauftrag t = (SepaDauerauftrag)this.schedule.getContext();
                Konto k = t.getKonto();
                return i18n.tr("SEPA-Dauerauftrag: {0} {1} an {2}\n{3}\n\n{4}\n\nKonto: {5}", new String[]{HBCI.DECIMALFORMAT.format(t.getBetrag()), k.getWaehrung(), t.getGegenkontoName(), TurnusHelper.createBezeichnung(t.getTurnus()), VerwendungszweckUtil.toString(t, "\n"), k.getLongName()});
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to build description", (Throwable)re);
                return null;
            }
        }

        public String getName() {
            try {
                SepaDauerauftrag t = (SepaDauerauftrag)this.schedule.getContext();
                Konto k = t.getKonto();
                return i18n.tr("{0} {1} an {2}", new String[]{HBCI.DECIMALFORMAT.format(t.getBetrag()), k.getWaehrung(), t.getGegenkontoName()});
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to build name", (Throwable)re);
                return i18n.tr("SEPA-Dauerauftrag");
            }
        }

        @Override
        public RGB getColor() {
            Date termin = this.schedule.getDate();
            if (termin != null && termin.before(new Date())) {
                return Color.COMMENT.getSWTColor().getRGB();
            }
            return Settings.getBuchungSollForeground().getRGB();
        }

        @Override
        public boolean hasAlarm() {
            return false;
        }
    }
}

