/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.calendar;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.calendar.AbstractAppointmentProvider;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.hbci.schedule.Schedule;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;

public class SepaSammelLastschriftAppointmentProvider
extends AbstractAppointmentProvider<SepaSammelLastschrift> {
    @Override
    AbstractAppointmentProvider.AbstractHibiscusAppointment createAppointment(Schedule<SepaSammelLastschrift> schedule) {
        return new MyAppointment(schedule);
    }

    private class MyAppointment
    extends AbstractAppointmentProvider.AbstractHibiscusAppointment {
        private MyAppointment(Schedule<SepaSammelLastschrift> schedule) {
            super(schedule);
        }

        public String getDescription() {
            try {
                SepaSammelLastschrift t = (SepaSammelLastschrift)this.schedule.getContext();
                Konto k = t.getKonto();
                return i18n.tr("{0}SEPA-Sammellastschrift: {1} {2} einziehen\n\n{3}\n\nKonto: {4}", new String[]{this.schedule.isPlanned() ? String.valueOf(i18n.tr("Geplant")) + ":\n" : "", HBCI.DECIMALFORMAT.format(t.getSumme()), k.getWaehrung(), t.getBezeichnung(), k.getLongName()});
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to build description", (Throwable)re);
                return null;
            }
        }

        public String getName() {
            try {
                SepaSammelLastschrift t = (SepaSammelLastschrift)this.schedule.getContext();
                Konto k = t.getKonto();
                return i18n.tr("{0} {1} {2}", new String[]{HBCI.DECIMALFORMAT.format(t.getSumme()), k.getWaehrung(), t.getBezeichnung()});
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to build name", (Throwable)re);
                return i18n.tr("SEPA-Sammellastschrift");
            }
        }
    }
}

