/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.calendar;

import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.calendar.AbstractAppointmentProvider;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.schedule.Schedule;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.RGB;

public class UmsatzAppointmentProvider
extends AbstractAppointmentProvider<Umsatz> {
    @Override
    AbstractAppointmentProvider.AbstractHibiscusAppointment createAppointment(Schedule<Umsatz> schedule) {
        return new MyAppointment(schedule);
    }

    private class MyAppointment
    extends AbstractAppointmentProvider.AbstractHibiscusAppointment {
        private MyAppointment(Schedule<Umsatz> schedule) {
            super(schedule);
        }

        public String getDescription() {
            try {
                Umsatz t = (Umsatz)this.schedule.getContext();
                Konto k = t.getKonto();
                double betrag = t.getBetrag();
                String rel = i18n.tr(betrag >= 0.0 ? "von" : "an");
                String zweck = VerwendungszweckUtil.toString(t, "\n");
                String name = StringUtils.trimToEmpty((String)t.getGegenkontoName());
                betrag = Math.abs(betrag);
                return i18n.tr("Umsatz: {0} {1} {2} {3}\n\n{4}\n\nKonto: {5}", new String[]{HBCI.DECIMALFORMAT.format(betrag), k.getWaehrung(), rel, name, zweck, k.getLongName()});
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to build description", (Throwable)re);
                return null;
            }
        }

        public String getName() {
            try {
                Umsatz t = (Umsatz)this.schedule.getContext();
                String curr = t.getKonto().getWaehrung();
                double betrag = t.getBetrag();
                String name = t.getGegenkontoName();
                String usage = t.getZweck();
                if (StringUtils.trimToNull((String)name) != null) {
                    return i18n.tr("{0} {1} {2}", new String[]{HBCI.DECIMALFORMAT.format(betrag), curr, name});
                }
                if (StringUtils.trimToNull((String)usage) != null) {
                    return i18n.tr("{0} {1} {2}", new String[]{HBCI.DECIMALFORMAT.format(betrag), curr, usage});
                }
                return i18n.tr("{0} {1}", new String[]{HBCI.DECIMALFORMAT.format(betrag), curr});
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to build name", (Throwable)re);
                return i18n.tr("Umsatz");
            }
        }

        @Override
        public RGB getColor() {
            try {
                Umsatz t = (Umsatz)this.schedule.getContext();
                double betrag = t.getBetrag();
                if (betrag > 0.0) {
                    return Settings.getBuchungHabenForeground().getRGB();
                }
                if (betrag < 0.0) {
                    return Settings.getBuchungSollForeground().getRGB();
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to detect color", (Throwable)e);
            }
            return Color.BLACK.getSWTColor().getRGB();
        }

        @Override
        public boolean hasAlarm() {
            return false;
        }
    }
}

