/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.experiments;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.experiments.Feature;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class FeatureService {
    private Settings settings = new Settings(FeatureService.class);
    private List<Feature> features = new LinkedList<Feature>();

    @PostConstruct
    private void init() {
        boolean enabled = this.enabled();
        if (enabled) {
            Logger.info((String)"loading experimental features");
        }
        try {
            Class[] found;
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            Class[] classArray = found = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader().getClassFinder().findImplementors(Feature.class);
            int n = found.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                try {
                    Feature f = (Feature)service.get(c);
                    this.features.add(f);
                    if (enabled) {
                        boolean state = this.isEnabled(f);
                        Logger.info((String)("  " + c.getSimpleName() + ": " + state));
                        f.setEnabled(state);
                    }
                }
                catch (Exception e) {
                    Logger.error((String)("unable to load feature " + c.getName() + ", skipping"), (Throwable)e);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to load experimental features", (Throwable)e);
        }
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public boolean isEnabled(Feature f) {
        if (!this.enabled()) {
            return f.getDefault();
        }
        return this.settings.getBoolean(f.getName(), f.getDefault());
    }

    public void setEnabled(Feature f, boolean enabled) {
        Logger.info((String)("set feature " + f.getName() + ": " + enabled));
        f.setEnabled(enabled);
        this.settings.setAttribute(f.getName(), enabled);
    }

    public boolean enabled() {
        return this.settings.getBoolean("enabled", false);
    }

    public void setEnabled(boolean b) {
        Logger.info((String)("feature service enabled: " + b));
        this.settings.setAttribute("enabled", b);
    }
}

