/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.forecast;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.jameica.hbci.forecast.ForecastProvider;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.schedule.Schedule;
import de.willuhn.jameica.hbci.schedule.ScheduleProvider;
import de.willuhn.jameica.hbci.schedule.ScheduleProviderFactory;
import de.willuhn.jameica.hbci.server.Value;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractForecastProvider<T extends HibiscusDBObject>
implements ForecastProvider {
    private ScheduleProvider provider = null;

    @Override
    public String getName() {
        ScheduleProvider provider = this.getScheduleProvider();
        return provider != null ? provider.getName() : "<unknown provider>";
    }

    @Override
    public List<Value> getData(Konto k, Date to) throws Exception {
        LinkedList<Value> result = new LinkedList<Value>();
        ScheduleProvider provider = this.getScheduleProvider();
        if (provider == null) {
            Logger.warn((String)("unable to determine schedule provider for " + this.getClass().getSimpleName()));
            return result;
        }
        List list = provider.getSchedules(k, DateUtil.startOfDay((Date)new Date()), to);
        for (Schedule schedule : list) {
            result.add(this.createValue(schedule));
        }
        return result;
    }

    abstract Value createValue(Schedule<T> var1) throws RemoteException;

    private ScheduleProvider getScheduleProvider() {
        if (this.provider == null) {
            this.provider = ScheduleProviderFactory.getScheduleProvider(BeanUtil.getType(this.getClass()));
        }
        return this.provider;
    }

    @Override
    public boolean isDefaultEnabled() {
        return true;
    }
}

