/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.forecast;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.forecast.ForecastProvider;
import de.willuhn.jameica.hbci.forecast.SaldoLimit;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.messaging.SaldoLimitsMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.hbci.server.Value;
import de.willuhn.jameica.hbci.util.SaldoFinder;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import de.willuhn.util.MultipleClassLoader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class ForecastCreator {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final Settings settings = new Settings(ForecastCreator.class);
    private static List<Class<ForecastProvider>> providers = null;
    private static List<SaldoLimit> limits = new ArrayList<SaldoLimit>();

    public static synchronized List<ForecastProvider> getProviders() {
        if (providers == null) {
            providers = new LinkedList<Class<ForecastProvider>>();
            try {
                Class[] classes;
                MultipleClassLoader loader = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader();
                Class[] classArray = classes = loader.getClassFinder().findImplementors(ForecastProvider.class);
                int n = classes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class c = classArray[n2];
                    providers.add(c);
                    ++n2;
                }
            }
            catch (ClassNotFoundException cne) {
                Logger.error((String)"no forecast providers found", (Throwable)cne);
            }
        }
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        LinkedList<ForecastProvider> result = new LinkedList<ForecastProvider>();
        for (Class<ForecastProvider> p : providers) {
            try {
                result.add((ForecastProvider)service.get(p));
            }
            catch (Exception e) {
                Logger.error((String)("unable to load " + p + " - skipping"), (Throwable)e);
            }
        }
        return result;
    }

    public static SaldoLimit getLimit(Konto k, SaldoLimit.Type type) {
        if (k == null || type == null) {
            return null;
        }
        SaldoLimit limit = new SaldoLimit(k, type);
        try {
            String prefix = "limit." + type.name().toLowerCase();
            String saldo = StringUtils.trimToNull((String)k.getMeta(String.valueOf(prefix) + ".saldo", null));
            String days = StringUtils.trimToNull((String)k.getMeta(String.valueOf(prefix) + ".days", null));
            boolean enabled = Boolean.valueOf(k.getMeta(String.valueOf(prefix) + ".enabled", "false"));
            boolean notify = Boolean.valueOf(k.getMeta(String.valueOf(prefix) + ".notify", "false"));
            limit.setEnabled(enabled);
            limit.setNotify(notify);
            if (saldo == null || days == null) {
                return limit;
            }
            double value = HBCI.DECIMALFORMAT.parse(saldo).doubleValue();
            int d = Integer.parseInt(days);
            if (d < 0) {
                Logger.warn((String)("invalid days: " + d));
                return limit;
            }
            limit.setDays(d);
            limit.setValue(value);
        }
        catch (Exception re) {
            Logger.error((String)("unable to load " + (Object)((Object)type) + " limit for account"), (Throwable)re);
        }
        return limit;
    }

    public static void setLimit(SaldoLimit limit) {
        try {
            Konto k = limit.getKonto();
            String prefix = "limit." + limit.getType().name().toLowerCase();
            k.setMeta(String.valueOf(prefix) + ".saldo", HBCI.DECIMALFORMAT.format(limit.getValue()));
            k.setMeta(String.valueOf(prefix) + ".days", Integer.toString(limit.getDays()));
            k.setMeta(String.valueOf(prefix) + ".enabled", Boolean.toString(limit.isEnabled()));
            k.setMeta(String.valueOf(prefix) + ".notify", Boolean.toString(limit.isNotify()));
            Application.getMessagingFactory().sendMessage((Message)new SaldoLimitsMessage());
        }
        catch (Exception re) {
            Logger.error((String)"unable to save limit for account", (Throwable)re);
        }
    }

    private static SaldoLimit checkLimit(Konto k, SaldoLimit.Type type) {
        SaldoLimit limit = ForecastCreator.getLimit(k, type);
        if (!limit.isEnabled()) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.add(5, limit.getDays());
        try {
            Date today = DateUtil.startOfDay((Date)new Date());
            List<Value> values = ForecastCreator.create(k, DateUtil.endOfDay((Date)cal.getTime()));
            if ((values == null || values.isEmpty()) && type.reached(k.getSaldo(), limit.getValue())) {
                limit.setDate(today);
                return limit;
            }
            for (Value v : values) {
                if (!type.reached(v.getValue(), limit.getValue())) continue;
                limit.setDate(v.getDate());
                return limit;
            }
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to check saldo limit", (Throwable)re);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Pr\u00fcfen des Saldolimits fehlgeschlagen"), 1));
        }
        return null;
    }

    public static List<SaldoLimit> getLimits() {
        return limits;
    }

    public static synchronized void updateLimits() {
        limits.clear();
        try {
            long started = System.currentTimeMillis();
            for (Konto k : KontoUtil.getKonten(KontoFilter.ACTIVE)) {
                SaldoLimit u;
                SaldoLimit l = ForecastCreator.checkLimit(k, SaldoLimit.Type.LOWER);
                if (l != null) {
                    limits.add(l);
                }
                if ((u = ForecastCreator.checkLimit(k, SaldoLimit.Type.UPPER)) == null) continue;
                limits.add(u);
            }
            long used = System.currentTimeMillis() - started;
            String msg = "recalculated saldo limits, found " + limits.size() + " limits, took " + used + " millis";
            if (used > 800L) {
                Logger.info((String)msg);
            } else {
                Logger.debug((String)msg);
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to check for saldo limits", (Throwable)e);
        }
    }

    public static List<Value> create(Konto k, Date to) throws RemoteException {
        Date from = DateUtil.startOfDay((Date)new Date());
        if (to == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(from);
            cal.add(1, 1);
            to = cal.getTime();
        }
        to = DateUtil.endOfDay((Date)to);
        TreeMap<Date, Value> dates = new TreeMap<Date, Value>();
        List<ForecastProvider> providers = ForecastCreator.getProviders();
        for (ForecastProvider p : providers) {
            if (!ForecastCreator.isEnabled(p)) continue;
            try {
                List<Value> values = p.getData(k, to);
                if (values == null || values.isEmpty()) continue;
                for (Value v : values) {
                    Value existing = (Value)dates.get(v.getDate());
                    if (existing != null) {
                        existing.setValue(existing.getValue() + v.getValue());
                        continue;
                    }
                    dates.put(v.getDate(), v);
                }
            }
            catch (Exception e) {
                Logger.error((String)("unable to calculate data from forecast provider \"" + p.getName() + "\", skipping"), (Throwable)e);
            }
        }
        double startSaldo = 0.0;
        if (k != null) {
            startSaldo = k.getNumUmsaetze() > 0 ? KontoUtil.getEndSaldo(k, from) : k.getSaldo();
        }
        LinkedList<Value> salden = new LinkedList<Value>();
        double prev = startSaldo;
        for (Value v : dates.values()) {
            Value newValue = new Value(v.getDate(), v.getValue() + prev);
            salden.add(newValue);
            prev = newValue.getValue();
        }
        LinkedList<Value> result = new LinkedList<Value>();
        SaldoFinder finder = new SaldoFinder(salden, startSaldo);
        Calendar cal = Calendar.getInstance();
        cal.setTime(from);
        while (!from.after(to)) {
            Value v = new Value(from, finder.get(from));
            result.add(v);
            cal.add(5, 1);
            from = cal.getTime();
        }
        return result;
    }

    public static boolean isEnabled(ForecastProvider provider) {
        return settings.getBoolean(String.valueOf(provider.getClass().getName()) + ".enabled", provider.isDefaultEnabled());
    }

    public static void setEnabled(ForecastProvider provider, boolean enabled) {
        settings.setAttribute(String.valueOf(provider.getClass().getName()) + ".enabled", enabled);
    }
}

