/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.forecast;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.forecast.ForecastProvider;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.hbci.server.Value;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class ForecastProviderUmsatz
implements ForecastProvider {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public String getName() {
        return i18n.tr("Ums\u00e4tze");
    }

    @Override
    public boolean isDefaultEnabled() {
        return false;
    }

    @Override
    public List<Value> getData(Konto k, Date to) throws Exception {
        Date end = DateUtil.endOfDay((Date)new Date());
        Calendar cal = Calendar.getInstance();
        cal.add(2, -6);
        Date start = DateUtil.startOfDay((Date)cal.getTime());
        HashMap<String, SumEntry> map = new HashMap<String, SumEntry>();
        DBIterator it = UmsatzUtil.find(k, null, start, end, null);
        HBCIDBService service = Settings.getDBService();
        it.setOrder("ORDER BY " + service.getSQLTimestamp("datum") + ", id");
        while (it.hasNext()) {
            Umsatz u = (Umsatz)it.next();
            String iban = u.getGegenkontoNummer();
            double d = u.getBetrag();
            Date date = u.getDatum();
            if (Double.isNaN(d) || date == null || Math.abs(d) <= 10.0) continue;
            SumEntry entry = map.computeIfAbsent(iban, i -> new SumEntry());
            cal.setTime(date);
            entry.add(cal.get(5), d);
        }
        ArrayList<Value> result = new ArrayList<Value>();
        int limit = 0;
        cal.setTime(DateUtil.startOfDay((Date)new Date()));
        while (!cal.getTime().after(to)) {
            if (limit++ >= 1000) break;
            int day = cal.get(5);
            for (SumEntry e : map.values()) {
                if (e.count < 2 || e.getDay() != day) continue;
                Value v = new Value(cal.getTime(), e.getValue());
                result.add(v);
            }
            cal.add(5, 1);
        }
        return result;
    }

    private class SumEntry {
        private int count = 0;
        private int days = 0;
        private double sum = 0.0;

        private SumEntry() {
        }

        private int getDay() {
            return this.days / this.count;
        }

        private double getValue() {
            return this.sum / (double)this.count;
        }

        private void add(int day, double value) {
            ++this.count;
            this.days += day;
            this.sum += value;
        }
    }
}

