/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.forecast;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.util.Date;

public class SaldoLimit {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Konto konto = null;
    private boolean enabled = false;
    private boolean notify = false;
    private double value = 0.0;
    private int days = 0;
    private Type type = null;
    private Date date = null;

    public SaldoLimit(Konto konto, Type type) {
        this.konto = konto;
        this.type = type;
    }

    public Konto getKonto() {
        return this.konto;
    }

    public Type getType() {
        return this.type;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public static enum Type {
        LOWER(-1, "Unteres Limit"),
        UPPER(1, "Oberes Limit");

        private int value = 0;
        private String desc = null;

        private Type(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getDescription() {
            return i18n.tr(this.desc);
        }

        public boolean reached(double saldo, double limit) {
            int cmp = Double.compare(saldo, limit);
            return cmp == 0 || cmp == this.value;
        }
    }
}

