/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.logging.Logger;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public class ColorUtil {
    private static final Map<String, org.eclipse.swt.graphics.Color> colorCache = new HashMap<String, org.eclipse.swt.graphics.Color>();

    public static org.eclipse.swt.graphics.Color getForeground(double value) {
        return ColorUtil.getColor(value, Settings.getBuchungSollForeground(), Settings.getBuchungHabenForeground(), de.willuhn.jameica.gui.util.Color.FOREGROUND.getSWTColor());
    }

    public static void setForeground(TableItem item, int col, double value) {
        boolean colorValue = Settings.getColorValues();
        if (colorValue) {
            item.setForeground(col, ColorUtil.getForeground(value));
        } else {
            item.setForeground(ColorUtil.getForeground(value));
        }
    }

    public static void setForeground(TreeItem item, int col, double value) {
        boolean colorValue = Settings.getColorValues();
        if (colorValue) {
            item.setForeground(col, ColorUtil.getForeground(value));
        } else {
            item.setForeground(ColorUtil.getForeground(value));
        }
    }

    public static void setForeground(TreeItem item, int col, UmsatzTyp ut) {
        org.eclipse.swt.graphics.Color color = ColorUtil.getColor(ut);
        if (color == null) {
            return;
        }
        if (col < 0) {
            item.setForeground(color);
        } else {
            item.setForeground(col, color);
        }
    }

    public static void setForeground(TableItem item, int col, UmsatzTyp ut) {
        org.eclipse.swt.graphics.Color color = ColorUtil.getColor(ut);
        if (color == null) {
            return;
        }
        if (col < 0) {
            item.setForeground(color);
        } else {
            item.setForeground(col, color);
        }
    }

    public static <T> T getColor(double value, T negative, T positive, T zero) {
        if (value <= -0.01) {
            return negative;
        }
        if (value >= 0.01) {
            return positive;
        }
        return zero;
    }

    public static org.eclipse.swt.graphics.Color getColor(UmsatzTyp ut) {
        int[] color;
        block5: {
            block4: {
                try {
                    if (ut != null && ut.isCustomColor()) break block4;
                    return null;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to determine color", (Throwable)e);
                    return null;
                }
            }
            color = ut.getColor();
            if (color != null && color.length == 3) break block5;
            return null;
        }
        RGB rgb = new RGB(color[0], color[1], color[2]);
        return colorCache.computeIfAbsent(rgb.toString(), s -> new org.eclipse.swt.graphics.Color((Device)GUI.getDisplay(), rgb));
    }

    public static int[] brighter(int[] color) {
        Color c = new Color(color[0], color[1], color[2]).brighter().brighter();
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        float f = 0.61f;
        float L = 0.3f * (float)r + 0.6f * (float)g + 0.1f * (float)b;
        int[] result = new int[]{(int)((float)r + 0.61f * (L - (float)r)), (int)((float)g + 0.61f * (L - (float)g)), (int)((float)b + 0.61f * (L - (float)b))};
        return result;
    }
}

