/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui;

import de.willuhn.jameica.hbci.AccountContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.dialogs.AccountContainerDialog;
import de.willuhn.jameica.hbci.gui.dialogs.PINDialog;
import de.willuhn.jameica.hbci.passports.rdh.KeyPasswordLoadDialog;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.kapott.hbci.passport.FileBasedPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportChipcard;
import org.kapott.hbci.passport.HBCIPassportPinTan;

public class DialogFactory {
    private static Map<String, PINEntry> pinCache = new HashMap<String, PINEntry>();
    private static long lastTry = 0L;

    public static synchronized String getPIN(HBCIPassport passport) throws Exception {
        PINEntry entry;
        String pin;
        boolean secondTry;
        boolean bl = secondTry = System.currentTimeMillis() - lastTry < 600L;
        if (secondTry) {
            Logger.warn((String)("cached pin seems to be wrong, asking user, passport: " + passport.getClass().getName()));
            DialogFactory.dirtyPINCache(passport);
        }
        String string = pin = (entry = DialogFactory.getCachedPIN(passport)) != null ? entry.getPIN() : null;
        if (pin != null && !secondTry && !entry.dirty) {
            Logger.info((String)("using cached pin, passport: " + passport.getClass().getName()));
            lastTry = System.currentTimeMillis();
            return pin;
        }
        lastTry = 0L;
        PINDialog dialog = new PINDialog(pin);
        pin = (String)dialog.open();
        DialogFactory.setCachedPIN(passport, pin);
        return pin;
    }

    public static synchronized String getKeyPassword(HBCIPassport passport) throws Exception {
        boolean secondTry;
        HBCI plugin = (HBCI)Application.getPluginLoader().getPlugin(HBCI.class);
        boolean forceAsk = plugin.getResources().getSettings().getBoolean("hbcicallback.askpassphrase.force", false);
        boolean bl = secondTry = System.currentTimeMillis() - lastTry < 600L;
        if (secondTry) {
            Logger.warn((String)("cached key seems to be wrong, asking user, passport: " + passport.getClass().getName()));
            DialogFactory.dirtyPINCache(passport);
        }
        String pw = null;
        if (!forceAsk && !secondTry) {
            PINEntry entry = DialogFactory.getCachedPIN(passport);
            String string = pw = entry != null ? entry.getPIN() : null;
            if (pw != null && !entry.dirty) {
                Logger.info((String)("using cached password, passport: " + passport.getClass().getName()));
                lastTry = System.currentTimeMillis();
                return pw;
            }
        }
        lastTry = 0L;
        KeyPasswordLoadDialog dialog = new KeyPasswordLoadDialog(passport, pw);
        pw = (String)dialog.open();
        if (!forceAsk) {
            DialogFactory.setCachedPIN(passport, pw);
        }
        return pw;
    }

    public static synchronized AccountContainer getAccountData(HBCIPassport p) throws Exception {
        AccountContainerDialog dialog = new AccountContainerDialog(p);
        return (AccountContainer)dialog.open();
    }

    private static PINEntry getCachedPIN(HBCIPassport passport) throws Exception {
        String s;
        String key = DialogFactory.getCacheKey(passport);
        if (key == null) {
            return null;
        }
        PINEntry entry = null;
        entry = pinCache.get(key);
        if (entry == null && Settings.getStorePin() && passport instanceof HBCIPassportPinTan && (s = (String)((Object)Settings.getWallet().get(key))) != null) {
            byte[] data = Base64.decode((String)s);
            Logger.info((String)"pin loaded from wallet");
            entry = new PINEntry(data);
            pinCache.put(key, entry);
        }
        return entry;
    }

    private static void setCachedPIN(HBCIPassport passport, String pin) throws Exception {
        String key = DialogFactory.getCacheKey(passport);
        if (key == null) {
            return;
        }
        PINEntry entry = new PINEntry(pin);
        pinCache.put(key, entry);
        if (entry != null && Settings.getStorePin() && passport instanceof HBCIPassportPinTan) {
            Settings.getWallet().set(key, (Serializable)((Object)Base64.encode((byte[])entry.crypted)));
        }
    }

    public static void clearPINCache(HBCIPassport passport) {
        if (passport != null) {
            String key = DialogFactory.getCacheKey(passport);
            if (key != null) {
                Logger.info((String)"pin cache cleared for single passport");
                pinCache.remove(key);
            }
        } else {
            Logger.info((String)"pin cache cleared for all passports");
            pinCache.clear();
        }
        DialogFactory.clearPINStore(passport);
    }

    public static void dirtyPINCache(HBCIPassport passport) {
        if (!Settings.getCachePin()) {
            DialogFactory.clearPINCache(passport);
            return;
        }
        if (passport != null) {
            String key = DialogFactory.getCacheKey(passport);
            if (key == null) {
                return;
            }
            PINEntry entry = pinCache.get(key);
            if (entry == null) {
                return;
            }
            Logger.warn((String)"mark pin cache dirty for single passport");
            entry.dirty = true;
            return;
        }
        Logger.warn((String)"mark pin cache dirty for all passports");
        for (PINEntry e : pinCache.values()) {
            e.dirty = true;
        }
    }

    public static void clearPINStore(HBCIPassport passport) {
        try {
            if (passport != null) {
                String key = DialogFactory.getCacheKey(passport);
                if (key != null && Settings.getWallet().get(key) != null) {
                    Logger.info((String)"pin store cleared for single passport");
                    Settings.getWallet().delete(key);
                }
            } else {
                Logger.info((String)"pin store cleared for all passports");
                Settings.getWallet().deleteAll("hibiscus.pin.");
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to clear pin cache", (Throwable)e);
        }
    }

    private static String getCacheKey(HBCIPassport passport) {
        if (passport == null) {
            Logger.debug((String)"no passport given - unable to generate cache key");
            return null;
        }
        String key = null;
        if (passport instanceof HBCIPassportPinTan) {
            key = ((HBCIPassportPinTan)passport).getFileName();
        } else if (passport instanceof FileBasedPassport) {
            key = ((FileBasedPassport)passport).getFilename();
        } else if (passport instanceof HBCIPassportChipcard && (key = ((HBCIPassportChipcard)passport).getFileName()) == null) {
            Logger.info((String)("have no passport filename for type [" + passport.getClass().getName() + "], pin cannot be cached"));
            return null;
        }
        if (key != null) {
            key = "hibiscus.pin." + key;
            Logger.debug((String)("using cache key: " + key));
            return key;
        }
        Logger.warn((String)("unknown passport type [" + passport.getClass().getName() + "], don't know, how to cache pin"));
        return null;
    }

    private static class PINEntry {
        private byte[] crypted;
        private boolean dirty = false;

        private PINEntry(String pin) throws Exception {
            ByteArrayInputStream bis = new ByteArrayInputStream(pin.getBytes());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Application.getSSLFactory().encrypt((InputStream)bis, (OutputStream)bos);
            this.crypted = bos.toByteArray();
        }

        private PINEntry(byte[] crypted) throws Exception {
            this.crypted = crypted;
        }

        private String getPIN() throws Exception {
            if (this.crypted == null) {
                return null;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(this.crypted);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Application.getSSLFactory().decrypt((InputStream)bis, (OutputStream)bos);
            String s = bos.toString();
            return s != null && s.length() > 0 ? s : null;
        }
    }
}

