/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.SepaSammelTransferDialog;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransfer;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;

public abstract class AbstractSepaSammelTransferExecute
implements Action {
    public void handleAction(Object context) throws ApplicationException {
        I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        if (!(context instanceof SepaSammelTransfer)) {
            throw new ApplicationException(i18n.tr("Bitte geben Sie einen SEPA-Sammelauftrag an"));
        }
        try {
            SepaSammelTransfer u = (SepaSammelTransfer)context;
            if (u.ausgefuehrt()) {
                throw new ApplicationException(i18n.tr("SEPA-Sammelauftrag wurde bereits ausgef\u00fchrt"));
            }
            if (u.getBuchungen().size() == 0) {
                throw new ApplicationException(i18n.tr("SEPA-Sammelauftrag enth\u00e4lt keine Buchungen"));
            }
            if (u.isNewObject()) {
                u.store();
            }
            if (u instanceof SepaSammelUeberweisung) {
                SepaSammelUeberweisung su = (SepaSammelUeberweisung)u;
                Date termin = DateUtil.startOfDay((Date)su.getTermin());
                Date now = DateUtil.startOfDay((Date)new Date());
                if (!su.isTerminUeberweisung() && termin.getTime() - now.getTime() >= 86400000L) {
                    String q = i18n.tr("Der Termin liegt mindestens 1 Tag in Zukunft.\nSoll der Auftrag stattdessen als bankseitige SEPA-Sammeltermin\u00fcberweisung ausgef\u00fchrt werden?");
                    if (Application.getCallback().askUser(q)) {
                        su.setTerminUeberweisung(true);
                        su.store();
                    }
                }
            }
            SepaSammelTransferDialog d = new SepaSammelTransferDialog(u, 1);
            try {
                if (!((Boolean)d.open()).booleanValue()) {
                    return;
                }
            }
            catch (OperationCanceledException oce) {
                Logger.info((String)oce.getMessage());
                return;
            }
            catch (Exception e) {
                Logger.error((String)"error while showing confirm dialog", (Throwable)e);
                GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Ausf\u00fchren des Sammel-Auftrages"));
                return;
            }
            this.execute(u);
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)oce.getMessage());
            return;
        }
        catch (Exception e) {
            Logger.error((String)"error while executing sammelauftrag", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Ausf\u00fchren des Sammel-Auftrages"), 1));
            return;
        }
    }

    abstract void execute(SepaSammelTransfer var1) throws ApplicationException, RemoteException;
}

