/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.ExportDialog;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransfer;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public abstract class AbstractSepaSammelTransferExport<T extends SepaSammelTransfer>
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (context == null || !(context instanceof SepaSammelTransfer) && !(context instanceof SepaSammelTransfer[])) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie mindestens einen SEPA-Sammelauftrag aus"));
        }
        try {
            Object[] list = null;
            list = context instanceof SepaSammelTransfer ? new SepaSammelTransfer[]{(SepaSammelTransfer)context} : (SepaSammelTransfer[])context;
            ExportDialog d = new ExportDialog(list, this.getExportClass());
            d.open();
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)oce.getMessage());
            return;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"error while exporting sepa sammeltransfer", (Throwable)e);
            GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Exportieren der SEPA-Sammelauftr\u00e4ge"));
        }
    }

    abstract Class<T> getExportClass();
}

