/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.DBObjectDelete;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class AuslandsUeberweisungDelete
extends DBObjectDelete {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public void handleAction(Object context) throws ApplicationException {
        if (context == null) {
            throw new ApplicationException(i18n.tr("Keine zu l\u00f6schenden Daten ausgew\u00e4hlt"));
        }
        if (!(context instanceof AuslandsUeberweisung) && !(context instanceof AuslandsUeberweisung[])) {
            Logger.warn((String)("wrong type to delete: " + context.getClass()));
            return;
        }
        try {
            boolean array = context instanceof AuslandsUeberweisung[];
            AuslandsUeberweisung[] list = null;
            list = array ? (AuslandsUeberweisung[])context : new AuslandsUeberweisung[]{(AuslandsUeberweisung)context};
            int count = 0;
            AuslandsUeberweisung[] auslandsUeberweisungArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                AuslandsUeberweisung a = auslandsUeberweisungArray[n2];
                if (!a.isNewObject() && a.ausgefuehrt() && a.isTerminUeberweisung()) {
                    ++count;
                }
                ++n2;
            }
            if (count > 0) {
                String msg = null;
                msg = array ? (count == 1 ? i18n.tr("Einer der Auftr\u00e4ge wurde bereits als bankseitige SEPA-Termin\u00fcberweisung gesendet.\nDas L\u00f6schen des Auftrages geschieht nur lokal in Hibiscus. Melden Sie sich\ndaher ggf. auf der Webseite Ihrer Bank an und l\u00f6schen den Auftrag auch dort,\nwenn er nicht ausgef\u00fchrt werden soll.\n\nAuftr\u00e4ge lokal in Hibiscus l\u00f6schen?") : i18n.tr("{0} Auftr\u00e4ge wurden bereits als bankseitige SEPA-Termin\u00fcberweisung gesendet.\nDas L\u00f6schen dieser Auftr\u00e4ge geschieht nur lokal in Hibiscus. Melden Sie sich\ndaher ggf. auf der Webseite Ihrer Bank an und l\u00f6schen diese auch dort,\nwenn sie nicht ausgef\u00fchrt werden sollen.\n\nAuftr\u00e4ge lokal in Hibiscus l\u00f6schen?", Integer.toString(count))) : i18n.tr("Der Auftrag wurde bereits als bankseitige SEPA-Termin\u00fcberweisung gesendet.\nDas L\u00f6schen des Auftrages geschieht nur lokal in Hibiscus. Melden Sie sich\ndaher ggf. auf der Webseite Ihrer Bank an und l\u00f6schen den Auftrag auch dort,\nwenn er nicht ausgef\u00fchrt werden soll.\n\nAuftrag lokal in Hibiscus l\u00f6schen?");
                if (!Application.getCallback().askUser(msg)) {
                    return;
                }
            }
        }
        catch (OperationCanceledException oce) {
            throw oce;
        }
        catch (Exception e) {
            Logger.error((String)"error while checking object", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Auftrag wurde bereits als Termin-\u00dcberweisung an Bank \u00fcbertragen"), 2));
        }
        super.handleAction(context);
    }
}

