/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.AuslandsUeberweisungDialog;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaUeberweisung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Arrays;
import java.util.Date;

public class AuslandsUeberweisungExecute
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (context == null || !(context instanceof AuslandsUeberweisung)) {
            throw new ApplicationException(i18n.tr("Kein Auftrag angegeben"));
        }
        try {
            AuslandsUeberweisung u = (AuslandsUeberweisung)context;
            if (u.ausgefuehrt()) {
                throw new ApplicationException(i18n.tr("\u00dcberweisung wurde bereits ausgef\u00fchrt"));
            }
            if (u.isNewObject()) {
                u.store();
            }
            Date termin = DateUtil.startOfDay((Date)u.getTermin());
            Date now = DateUtil.startOfDay((Date)new Date());
            if (!u.isTerminUeberweisung() && termin.getTime() - now.getTime() >= 86400000L) {
                String q = i18n.tr("Der Termin liegt mindestens 1 Tag in Zukunft.\nSoll der Auftrag stattdessen als bankseitige SEPA-Termin\u00fcberweisung ausgef\u00fchrt werden?");
                if (Application.getCallback().askUser(q)) {
                    u.setTerminUeberweisung(true);
                    u.store();
                }
            }
            AuslandsUeberweisungDialog d = new AuslandsUeberweisungDialog(u, 1);
            try {
                if (!((Boolean)d.open()).booleanValue()) {
                    return;
                }
            }
            catch (OperationCanceledException oce) {
                Logger.info((String)oce.getMessage());
                return;
            }
            catch (Exception e) {
                Logger.error((String)"error while showing confirm dialog", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Ausf\u00fchren der \u00dcberweisung"), 1));
                return;
            }
            Konto konto = u.getKonto();
            Class<SynchronizeJobSepaUeberweisung> type = SynchronizeJobSepaUeberweisung.class;
            BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            SynchronizeEngine engine = (SynchronizeEngine)bs.get(SynchronizeEngine.class);
            SynchronizeBackend backend = engine.getBackend(type, konto);
            SynchronizeJob job = (SynchronizeJob)backend.create(type, konto);
            job.setContext("ctx.entity", u);
            backend.execute(Arrays.asList(job));
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"error while executing transfer", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Ausf\u00fchren der \u00dcberweisung: {0}", e.getMessage()), 1));
        }
    }
}

