/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.jost_net.OBanToo.SEPA.IBAN;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.io.ClipboardSepaUeberweisungImporter;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.AddressbookService;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisung;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisungBuchung;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class AuslandsUeberweisungNew
implements Action {
    public void handleAction(Object context) throws ApplicationException {
        AuslandsUeberweisung u;
        block14: {
            u = null;
            try {
                if (context instanceof AuslandsUeberweisung) {
                    u = (AuslandsUeberweisung)context;
                    break block14;
                }
                if (context instanceof Konto) {
                    Konto k = (Konto)context;
                    u = (AuslandsUeberweisung)Settings.getDBService().createObject(AuslandsUeberweisung.class, null);
                    if (!k.hasFlag(1) && !k.hasFlag(2) && StringUtils.trimToNull((String)k.getIban()) != null) {
                        u.setKonto(k);
                    }
                    break block14;
                }
                if (context instanceof Address) {
                    Address e = (Address)context;
                    u = (AuslandsUeberweisung)Settings.getDBService().createObject(AuslandsUeberweisung.class, null);
                    u.setGegenkonto(e);
                    break block14;
                }
                if (context instanceof Umsatz) {
                    IBAN iban;
                    Umsatz umsatz = (Umsatz)context;
                    u = (AuslandsUeberweisung)Settings.getDBService().createObject(AuslandsUeberweisung.class, null);
                    u.setBetrag(Math.abs(umsatz.getBetrag()));
                    u.setGegenkontoName(umsatz.getGegenkontoName());
                    u.setKonto(umsatz.getKonto());
                    u.setTermin(new Date());
                    String kto = StringUtils.trimToEmpty((String)umsatz.getGegenkontoNummer());
                    String blz = StringUtils.trimToEmpty((String)umsatz.getGegenkontoBLZ());
                    if (kto.length() <= 10 && kto.length() > 0 && blz.length() > 0) {
                        HibiscusAddress address = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, null);
                        address.setBlz(blz);
                        address.setKontonummer(kto);
                        AddressbookService book = (AddressbookService)Application.getServiceFactory().lookup(HBCI.class, "addressbook");
                        Address a = book.contains(address);
                        kto = a != null ? a.getIban() : null;
                        String string = blz = a != null ? a.getBic() : null;
                    }
                    if ((blz == null || blz.length() != HBCIProperties.HBCI_BIC_MAXLENGTH) && (iban = HBCIProperties.getIBAN(kto)) != null) {
                        blz = iban.getBIC();
                    }
                    u.setGegenkontoBLZ(blz);
                    u.setGegenkontoNummer(kto);
                    u.setZweck(VerwendungszweckUtil.toString(umsatz));
                    break block14;
                }
                if (context instanceof SepaSammelUeberweisungBuchung) {
                    try {
                        SepaSammelUeberweisungBuchung b = (SepaSammelUeberweisungBuchung)context;
                        SepaSammelUeberweisung st = (SepaSammelUeberweisung)b.getSammelTransfer();
                        u = (AuslandsUeberweisung)Settings.getDBService().createObject(AuslandsUeberweisung.class, null);
                        u.setBetrag(b.getBetrag());
                        u.setGegenkontoBLZ(b.getGegenkontoBLZ());
                        u.setGegenkontoName(b.getGegenkontoName());
                        u.setGegenkontoNummer(b.getGegenkontoNummer());
                        u.setZweck(b.getZweck());
                        u.setEndtoEndId(b.getEndtoEndId());
                        if (st != null) {
                            u.setKonto(st.getKonto());
                            u.setTermin(st.getTermin());
                        }
                        break block14;
                    }
                    catch (RemoteException re) {
                        Logger.error((String)"error while creating transfer", (Throwable)re);
                    }
                    break block14;
                }
                ClipboardSepaUeberweisungImporter i = new ClipboardSepaUeberweisungImporter();
                u = i.getUeberweisung();
            }
            catch (OperationCanceledException | ApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.error((String)"error while creating transfer", (Throwable)e);
            }
        }
        GUI.startView(de.willuhn.jameica.hbci.gui.views.AuslandsUeberweisungNew.class, (Object)u);
    }
}

