/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.GenericObjectNode;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.datasource.rmi.DBObjectNode;
import de.willuhn.datasource.serialize.Writer;
import de.willuhn.datasource.serialize.XmlWriter;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.server.AuslandsUeberweisungImpl;
import de.willuhn.jameica.hbci.server.DBPropertyImpl;
import de.willuhn.jameica.hbci.server.DBReminderImpl;
import de.willuhn.jameica.hbci.server.DauerauftragImpl;
import de.willuhn.jameica.hbci.server.HibiscusAddressImpl;
import de.willuhn.jameica.hbci.server.KontoImpl;
import de.willuhn.jameica.hbci.server.KontoauszugImpl;
import de.willuhn.jameica.hbci.server.LastschriftImpl;
import de.willuhn.jameica.hbci.server.NachrichtImpl;
import de.willuhn.jameica.hbci.server.ProtokollImpl;
import de.willuhn.jameica.hbci.server.SammelLastBuchungImpl;
import de.willuhn.jameica.hbci.server.SammelLastschriftImpl;
import de.willuhn.jameica.hbci.server.SammelUeberweisungBuchungImpl;
import de.willuhn.jameica.hbci.server.SammelUeberweisungImpl;
import de.willuhn.jameica.hbci.server.SepaDauerauftragImpl;
import de.willuhn.jameica.hbci.server.SepaLastschriftImpl;
import de.willuhn.jameica.hbci.server.SepaSammelLastBuchungImpl;
import de.willuhn.jameica.hbci.server.SepaSammelLastschriftImpl;
import de.willuhn.jameica.hbci.server.SepaSammelUeberweisungBuchungImpl;
import de.willuhn.jameica.hbci.server.SepaSammelUeberweisungImpl;
import de.willuhn.jameica.hbci.server.TurnusImpl;
import de.willuhn.jameica.hbci.server.UeberweisungImpl;
import de.willuhn.jameica.hbci.server.UmsatzImpl;
import de.willuhn.jameica.hbci.server.UmsatzTypImpl;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.widgets.FileDialog;

public class BackupCreate
implements Action {
    public static DateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        FileDialog fd = new FileDialog(GUI.getShell(), 8192);
        fd.setFilterPath(System.getProperty("user.home"));
        fd.setOverwrite(true);
        fd.setFileName("hibiscus-backup-" + DATEFORMAT.format(new Date()) + ".xml");
        fd.setFilterExtensions(new String[]{"*.xml"});
        fd.setText("Bitte w\u00e4hlen Sie die Datei, in der das Backup gespeichert wird");
        String f = fd.open();
        if (f == null || f.length() == 0) {
            return;
        }
        final File file = new File(f);
        Application.getController().start(new BackgroundTask(){
            private boolean cancel = false;

            public void run(ProgressMonitor monitor) throws ApplicationException {
                XmlWriter writer = null;
                try {
                    try {
                        Logger.info((String)("creating xml backup to " + file.getAbsolutePath()));
                        writer = new XmlWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
                        monitor.setStatusText(i18n.tr("Speichere Turnus-Informationen"));
                        BackupCreate.backup(TurnusImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere Adressbuch"));
                        BackupCreate.backup(HibiscusAddressImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere Konten und Systemnachrichten"));
                        BackupCreate.backup(KontoImpl.class, (Writer)writer, monitor);
                        BackupCreate.backup(NachrichtImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere Umsatz-Kategorien"));
                        BackupCreate.backupTree(UmsatzTypImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere Ums\u00e4tze"));
                        BackupCreate.backup(UmsatzImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(20);
                        monitor.setStatusText(i18n.tr("Speichere Dauerauftr\u00e4ge"));
                        BackupCreate.backup(DauerauftragImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere SEPA-Dauerauftr\u00e4ge"));
                        BackupCreate.backup(SepaDauerauftragImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere Lastschriften"));
                        BackupCreate.backup(LastschriftImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere \u00dcberweisungen"));
                        BackupCreate.backup(UeberweisungImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere SEPA-\u00dcberweisungen"));
                        BackupCreate.backup(AuslandsUeberweisungImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere SEPA-Lastschriften"));
                        BackupCreate.backup(SepaLastschriftImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere Sammel-Lastschriften"));
                        BackupCreate.backup(SammelLastschriftImpl.class, (Writer)writer, monitor);
                        BackupCreate.backup(SammelLastBuchungImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere Sammel-\u00dcberweisungen"));
                        BackupCreate.backup(SammelUeberweisungImpl.class, (Writer)writer, monitor);
                        BackupCreate.backup(SammelUeberweisungBuchungImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere SEPA-Sammellastschriften"));
                        BackupCreate.backup(SepaSammelLastschriftImpl.class, (Writer)writer, monitor);
                        BackupCreate.backup(SepaSammelLastBuchungImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere SEPA-Sammel\u00fcberweisungen"));
                        BackupCreate.backup(SepaSammelUeberweisungImpl.class, (Writer)writer, monitor);
                        BackupCreate.backup(SepaSammelUeberweisungBuchungImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere Kontoausz\u00fcge"));
                        BackupCreate.backup(KontoauszugImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(5);
                        monitor.setStatusText(i18n.tr("Speichere Properties"));
                        BackupCreate.backup(DBPropertyImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(10);
                        monitor.setStatusText(i18n.tr("Speichere Reminder"));
                        BackupCreate.backup(DBReminderImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(2);
                        monitor.setStatusText(i18n.tr("Speichere Protokolle"));
                        BackupCreate.backup(ProtokollImpl.class, (Writer)writer, monitor);
                        monitor.addPercentComplete(20);
                        monitor.setStatus(4);
                        monitor.setStatusText("Backup erstellt");
                        monitor.setPercentComplete(100);
                    }
                    catch (Exception e) {
                        throw new ApplicationException(e.getMessage());
                    }
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                            Logger.info((String)"backup created");
                        }
                        catch (Exception exception) {}
                    }
                }
            }

            public boolean isInterrupted() {
                return this.cancel;
            }

            public void interrupt() {
                this.cancel = true;
            }
        });
    }

    private static void backup(Class<? extends DBObject> type, Writer writer, ProgressMonitor monitor) throws Exception {
        DBIterator list = Settings.getDBService().createList(type);
        list.setOrder("order by id");
        long count = 1L;
        while (list.hasNext()) {
            GenericObject o = null;
            try {
                o = list.next();
                writer.write(o);
                if (count++ % 200L != 0L) continue;
                monitor.addPercentComplete(1);
            }
            catch (Exception e) {
                Logger.error((String)("error while writing object " + BeanUtil.toString((Object)o) + " - skipping"), (Throwable)e);
                monitor.log("  " + i18n.tr("{0} fehlerhaft ({1}), \u00fcberspringe", new String[]{BeanUtil.toString((Object)o), e.getMessage()}));
            }
        }
    }

    private static void backupTree(Class<? extends DBObjectNode> type, Writer writer, ProgressMonitor monitor) throws Exception {
        DBIterator root = Settings.getDBService().createList(type);
        root.addFilter("parent_id is null");
        root.setOrder("order by id");
        while (root.hasNext()) {
            GenericObjectNode o = null;
            try {
                o = (GenericObjectNode)root.next();
                BackupCreate.backupNode(o, writer, monitor);
                monitor.addPercentComplete(1);
            }
            catch (Exception e) {
                Logger.error((String)("error while writing object " + BeanUtil.toString((Object)o) + " - skipping"), (Throwable)e);
                monitor.log("  " + i18n.tr("{0} fehlerhaft ({1}), \u00fcberspringe", new String[]{BeanUtil.toString((Object)o), e.getMessage()}));
            }
        }
    }

    private static void backupNode(GenericObjectNode node, Writer writer, ProgressMonitor monitor) throws Exception {
        try {
            writer.write((GenericObject)node);
            GenericIterator children = node.getChildren();
            if (children != null) {
                while (children.hasNext()) {
                    BackupCreate.backupNode((GenericObjectNode)children.next(), writer, monitor);
                }
            }
        }
        catch (Exception e) {
            Logger.error((String)("error while writing object " + BeanUtil.toString((Object)node) + " - skipping"), (Throwable)e);
            monitor.log("  " + i18n.tr("{0} fehlerhaft ({1}), \u00fcberspringe", new String[]{BeanUtil.toString((Object)node), e.getMessage()}));
        }
    }
}

