/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.db.AbstractDBObject;
import de.willuhn.datasource.serialize.ObjectFactory;
import de.willuhn.datasource.serialize.XmlReader;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.BackupCreate;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Protokoll;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.MultipleClassLoader;
import de.willuhn.util.ProgressMonitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.eclipse.swt.widgets.FileDialog;

public class BackupRestore
implements Action {
    private static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        try {
            if (Settings.getDBService().createList(Konto.class).size() > 0) {
                String text = i18n.tr("Die Hibiscus-Installation enth\u00e4lt bereits Daten.\nDas Backup kann nur in eine neue Hibiscus-Installation importiert werden.");
                Application.getCallback().notifyUser(text);
                return;
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (OperationCanceledException oce) {
            return;
        }
        catch (Exception e) {
            Logger.error((String)"unable to notify user", (Throwable)e);
            throw new ApplicationException(i18n.tr("Datenbank-Import fehlgeschlagen"));
        }
        FileDialog fd = new FileDialog(GUI.getShell(), 4096);
        fd.setFileName("hibiscus-backup-" + BackupCreate.DATEFORMAT.format(new Date()) + ".xml");
        fd.setFilterExtensions(new String[]{"*.xml"});
        fd.setText("Bitte w\u00e4hlen Sie die Backup-Datei aus");
        String f = fd.open();
        if (f == null || f.length() == 0) {
            return;
        }
        final File file = new File(f);
        if (!file.exists()) {
            return;
        }
        Application.getController().start(new BackgroundTask(){
            private boolean cancel = false;

            public void run(ProgressMonitor monitor) throws ApplicationException {
                monitor.setStatusText(i18n.tr("Importiere Backup"));
                Logger.info((String)("importing backup " + file.getAbsolutePath()));
                MultipleClassLoader loader = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader();
                XmlReader reader = null;
                try {
                    try {
                        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                        reader = new XmlReader((InputStream)is, new ObjectFactory((ClassLoader)loader){
                            private final /* synthetic */ ClassLoader val$loader;
                            {
                                this.val$loader = classLoader;
                            }

                            public GenericObject create(String type, String id, Map values) throws Exception {
                                AbstractDBObject object = (AbstractDBObject)Settings.getDBService().createObject(this.val$loader.loadClass(type), null);
                                object.setID(id);
                                for (String name : values.keySet()) {
                                    object.setAttribute(name, values.get(name));
                                }
                                return object;
                            }
                        });
                        long count = 1L;
                        GenericObject o = null;
                        while ((o = reader.read()) != null) {
                            try {
                                ((AbstractDBObject)o).insert();
                            }
                            catch (Exception e) {
                                if (o instanceof Protokoll) {
                                    Logger.write((Level)Level.DEBUG, (String)("unable to import " + o.getClass().getName() + ":" + o.getID() + ", skipping"), (Throwable)e);
                                }
                                Logger.error((String)("unable to import " + o.getClass().getName() + ":" + o.getID() + ", skipping"), (Throwable)e);
                                monitor.log("  " + i18n.tr("{0} fehlerhaft ({1}), \u00fcberspringe", new String[]{BeanUtil.toString((Object)o), e.getMessage()}));
                            }
                            if (count++ % 100L != 0L) continue;
                            monitor.addPercentComplete(1);
                        }
                        monitor.setStatus(4);
                        monitor.setStatusText("Backup importiert");
                        monitor.setPercentComplete(100);
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while importing data", (Throwable)e);
                        throw new ApplicationException(e.getMessage());
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                            Logger.info((String)"backup imported");
                        }
                        catch (Exception exception) {}
                    }
                }
            }

            public boolean isInterrupted() {
                return this.cancel;
            }

            public void interrupt() {
                this.cancel = true;
            }
        });
    }
}

