/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.passports.pintan.ChipTANDialog;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.apache.commons.lang.StringUtils;

public class ChipTanTest
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        try {
            ChipTANDialog d = new ChipTANDialog(null, "1784011041875F051234567890041203000044302C323015");
            d.setTitle(i18n.tr("chipTAN-Test"));
            d.setText(i18n.tr("Verwenden Sie diese Flicker-Grafik, um die Funktionsf\u00e4higkeit Ihres TAN-Generators zu testen.\n\n1. Schieben Sie Ihre Bank-Karte in den TAN-Generator\n2. Halten Sie das Ger\u00e4t b\u00fcndig an den Bildschirm vor die blinkenden Balken. Die wei\u00dfen\n    Positionsdreiecke sollten zwischen Bildschirm und TAN-Generator \u00fcbereinstimmen\n3. Passen Sie mit den Tasten \"-\" und \"+\" ggf. die Breite der Flicker-Grafik an\n4. Dr\u00fccken Sie die Taste \"F\", um den Scan-Vorgang zu starten\n5. Wenn der Flicker-Code erfolgreich \u00fcbertragen wurde, sollte auf dem Ger\u00e4t der Text\n    \"\u00dcberweisung Inland\" angezeigt werden.\n6. Nach mehrmaligem Dr\u00fccken der Taste \"OK\" sollten\n    \"Konto Empf: 1234567890\"\n    \"BLZ Empf: 12030000\"\n    \"Betrag: 0,20\"\n    angezeigt werden\n7. Nach einer weiterer Best\u00e4tigung mit \"OK\" sollte eine TAN generiert werden.\n"));
            String tan = StringUtils.trimToNull((String)((String)d.open()));
            if (tan != null) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Eingegebene TAN: {0}", tan), 0));
            } else {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Keine TAN eingegeben"), 2));
            }
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"chipTAN-Test abgebrochen");
        }
        catch (Exception e) {
            Logger.error((String)"error while testing chipTAN", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("chipTAN-Test fehlgeschlagen: {0}", e.getMessage()), 1));
        }
    }
}

