/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.YesNoDialog;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.messaging.ObjectDeletedMessage;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.rmi.RemoteException;

public class DBObjectDelete
implements Action {
    private I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (context == null) {
            throw new ApplicationException(this.i18n.tr("Keine zu l\u00f6schenden Daten ausgew\u00e4hlt"));
        }
        if (!(context instanceof DBObject) && !(context instanceof DBObject[])) {
            Logger.warn((String)("wrong type to delete: " + context.getClass()));
            return;
        }
        boolean array = context instanceof DBObject[];
        YesNoDialog d = new YesNoDialog(1);
        if (array) {
            d.setTitle(this.i18n.tr("Daten l\u00f6schen"));
            d.setText(this.i18n.tr("Wollen Sie diese {0} Datens\u00e4tze wirklich l\u00f6schen?", "" + ((DBObject[])context).length));
        } else {
            d.setTitle(this.i18n.tr("Daten l\u00f6schen"));
            d.setText(this.i18n.tr("Wollen Sie diesen Datensatz wirklich l\u00f6schen?"));
        }
        try {
            Boolean choice = (Boolean)d.open();
            if (!choice.booleanValue()) {
                return;
            }
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)oce.getMessage());
            return;
        }
        catch (Exception e) {
            Logger.error((String)"error while deleting objects", (Throwable)e);
            GUI.getStatusBar().setErrorText(this.i18n.tr("Fehler beim L\u00f6schen des Datensatzes"));
            return;
        }
        DBObject[] list = null;
        list = array ? (DBObject[])context : new DBObject[]{(DBObject)context};
        Worker worker = new Worker(list);
        worker.run(null);
    }

    private class Worker
    implements BackgroundTask {
        private boolean cancel = false;
        private DBObject[] list = null;

        private Worker(DBObject[] list) {
            this.list = list;
        }

        public void interrupt() {
            this.cancel = true;
        }

        public boolean isInterrupted() {
            return this.cancel;
        }

        public void run(ProgressMonitor monitor) throws ApplicationException {
            try {
                if (monitor != null) {
                    monitor.setStatusText(DBObjectDelete.this.i18n.tr("L\u00f6sche {0} Datens\u00e4tze", "" + this.list.length));
                }
                double factor = 100.0 / (double)this.list.length;
                int i = 0;
                while (i < this.list.length) {
                    if (monitor != null && i % 4 == 0) {
                        monitor.setPercentComplete((int)((double)(i + 4) * factor));
                    }
                    if (!this.list[i].isNewObject()) {
                        String id = this.list[i].getID();
                        this.list[i].delete();
                        Application.getMessagingFactory().sendMessage((Message)new ObjectDeletedMessage((GenericObject)this.list[i], id));
                    }
                    ++i;
                }
                if (monitor != null) {
                    monitor.setPercentComplete(100);
                }
                String text = DBObjectDelete.this.i18n.tr("Datensatz gel\u00f6scht.");
                if (this.list.length > 1) {
                    text = DBObjectDelete.this.i18n.tr("{0} Datens\u00e4tze gel\u00f6scht.", "" + this.list.length);
                }
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(text, 0));
                if (monitor != null) {
                    monitor.setStatusText(text);
                    monitor.setStatus(4);
                }
            }
            catch (RemoteException e) {
                Logger.error((String)"error while deleting objects", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(DBObjectDelete.this.i18n.tr("Fehler beim L\u00f6schen der Datens\u00e4tze."), 1));
                if (monitor != null) {
                    monitor.setStatus(3);
                    monitor.setStatusText(DBObjectDelete.this.i18n.tr("Fehler beim L\u00f6schen der Daten"));
                    monitor.log(e.toString());
                }
            }
            catch (ApplicationException ae) {
                if (monitor != null) {
                    monitor.setStatus(3);
                    monitor.setStatusText(ae.getMessage());
                }
                throw ae;
            }
        }
    }
}

