/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.AddressbookService;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.Transfer;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;

public class EmpfaengerAdd
implements Action {
    public void handleAction(Object context) throws ApplicationException {
        I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        if (context == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein oder mehrere Auftr\u00e4ge aus"));
        }
        if (!(context instanceof Transfer || context instanceof Transfer[] || context instanceof Address || context instanceof Address[] || context instanceof Umsatz || context instanceof Umsatz[])) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein oder mehrere Auftr\u00e4ge aus"));
        }
        ArrayList<Remote> items = new ArrayList<Remote>();
        try {
            int i;
            Remote[] list;
            if (context instanceof Transfer) {
                Transfer t = (Transfer)context;
                items.add(this.create(t.getGegenkontoName(), t.getGegenkontoNummer(), t.getGegenkontoBLZ()));
            } else if (context instanceof Transfer[]) {
                list = (Transfer[])context;
                i = 0;
                while (i < list.length) {
                    Remote t = list[i];
                    items.add(this.create(t.getGegenkontoName(), t.getGegenkontoNummer(), t.getGegenkontoBLZ()));
                    ++i;
                }
            } else if (context instanceof HibiscusAddress) {
                items.add((HibiscusAddress)context);
            } else if (context instanceof HibiscusAddress[]) {
                list = (HibiscusAddress[])context;
                i = 0;
                while (i < list.length) {
                    items.add(list[i]);
                    ++i;
                }
            } else if (context instanceof Address) {
                Address a = (Address)context;
                items.add(this.create(a.getName(), a.getKontonummer(), a.getBlz()));
            } else if (context instanceof Address[]) {
                list = (Address[])context;
                i = 0;
                while (i < list.length) {
                    Remote a = list[i];
                    items.add(this.create(a.getName(), a.getKontonummer(), a.getBlz()));
                    ++i;
                }
            }
            if (items.size() == 0) {
                return;
            }
            HashMap<String, HibiscusAddress> seen = new HashMap<String, HibiscusAddress>();
            AddressbookService book = (AddressbookService)Application.getServiceFactory().lookup(HBCI.class, "addressbook");
            int count = 0;
            int i2 = 0;
            while (i2 < items.size()) {
                HibiscusAddress e = (HibiscusAddress)items.get(i2);
                if (e.getName() == null || e.getName().length() == 0) {
                    Logger.warn((String)("address [kto. " + e.getKontonummer() + ", blz " + e.getBlz() + " has no name, skipping"));
                } else {
                    String key = String.valueOf(e.getName()) + "-" + e.getKontonummer() + "-" + e.getBlz() + "-" + e.getIban();
                    if (seen.get(key) == null) {
                        seen.put(key, e);
                        if (book.contains(e) != null) {
                            Logger.debug((String)("address [iban. " + e.getIban() + ", bic " + e.getBic() + " already exists, skipping"));
                        } else {
                            e.store();
                            ++count;
                        }
                    }
                }
                ++i2;
            }
            if (count > 0) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Adresse{0} gespeichert", count > 1 ? "n" : ""), 0));
            } else {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Adresse existiert bereits"), 2));
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"error while storing empfaenger", (Throwable)e);
            GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Speichern des Empf\u00e4ngers"));
        }
    }

    private HibiscusAddress create(String name, String kontonummer, String blz) throws RemoteException {
        HibiscusAddress e = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, null);
        e.setName(this.strip(name));
        if (kontonummer != null && kontonummer.matches("[a-zA-Z]{2}.*")) {
            e.setIban(kontonummer);
        } else {
            e.setKontonummer(kontonummer);
        }
        if (blz != null && blz.matches("[a-zA-Z]{6}.*")) {
            e.setBic(blz);
        } else {
            e.setBlz(blz);
        }
        return e;
    }

    private String strip(String s) {
        if (s == null || s.length() < HBCIProperties.HBCI_TRANSFER_NAME_MAXLENGTH) {
            return s;
        }
        return s.substring(0, HBCIProperties.HBCI_TRANSFER_NAME_MAXLENGTH);
    }
}

