/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.ExportDialog;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class Export
implements Action {
    protected static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Class type = null;
    private Object data = null;

    public Export(Class type) {
        this.type = type;
    }

    public Export(Class type, Object data) {
        this(type);
        this.data = data;
    }

    public void handleAction(Object context) throws ApplicationException {
        Object export;
        Object object = export = this.data != null ? this.data : context;
        if (export == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu exportierenden Daten aus"));
        }
        Object[] objects = null;
        objects = export instanceof Object[] ? (Object[])export : new Object[]{export};
        try {
            ExportDialog d = new ExportDialog(objects, this.type);
            d.open();
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)oce.getMessage());
            return;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"export failed", (Throwable)e);
            throw new ApplicationException(i18n.tr("Export fehlgeschlagen: {0}", e.getMessage()), (Throwable)e);
        }
    }
}

