/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.Flaggable;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class FlaggableChange
implements Action {
    protected static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private int flags = 0;
    private boolean add = true;

    public FlaggableChange(int flags, boolean add) {
        this.flags = flags;
        this.add = add;
    }

    public void handleAction(Object context) throws ApplicationException {
        if (context == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Datens\u00e4tze aus"));
        }
        if (!(context instanceof Flaggable) && !(context instanceof Flaggable[])) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Datens\u00e4tze aus"));
        }
        Flaggable[] objects = null;
        objects = context instanceof Flaggable ? new Flaggable[]{(Flaggable)context} : (Flaggable[])context;
        if (objects.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Datens\u00e4tze aus"));
        }
        try {
            objects[0].transactionBegin();
            int i = 0;
            while (i < objects.length) {
                int current = objects[i].getFlags();
                boolean have = objects[i].hasFlag(this.flags);
                if (this.add && !have) {
                    objects[i].setFlags(current | this.flags);
                } else if (!this.add && have) {
                    objects[i].setFlags(current ^ this.flags);
                }
                this.postProcess(objects[i]);
                objects[i].store();
                Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)objects[i]));
                ++i;
            }
            objects[0].transactionCommit();
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("\u00c4nderungen gespeichert"), 0));
        }
        catch (Exception e) {
            try {
                objects[0].transactionRollback();
            }
            catch (Exception e1) {
                Logger.error((String)"unable to rollback transaction", (Throwable)e1);
            }
            if (e instanceof ApplicationException) {
                throw (ApplicationException)((Object)e);
            }
            Logger.error((String)"error while setting flags", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Speichern der \u00c4nderungen"));
        }
    }

    protected void postProcess(Flaggable o) throws Exception {
    }

    protected int getFlags() {
        return this.flags;
    }

    protected boolean getAdd() {
        return this.add;
    }
}

