/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.EmpfaengerAdd;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.server.HibiscusAddressImpl;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Objects;

public class HibiscusAddressUpdate
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private HibiscusAddress address = null;
    private boolean create = false;

    public void setAddress(Address a) {
        if (a instanceof HibiscusAddress) {
            this.address = (HibiscusAddress)a;
        }
    }

    public void setCreate(boolean b) {
        this.create = b;
    }

    public void handleAction(Object context) throws ApplicationException {
        if (this.address == null) {
            if (this.create) {
                new EmpfaengerAdd().handleAction(context);
            }
            return;
        }
        if (context == null || !(context instanceof HibiscusAddress)) {
            return;
        }
        HibiscusAddress newAddress = (HibiscusAddress)context;
        try {
            boolean ibanChanged = this.changed(this.address.getIban(), newAddress.getIban(), false);
            boolean bicChanged = this.changed(this.address.getBic(), newAddress.getBic(), false);
            boolean nameChanged = this.changed(this.address.getName(), newAddress.getName(), true);
            if (!(ibanChanged || bicChanged || nameChanged)) {
                return;
            }
            if (!Application.getCallback().askUser(i18n.tr("Die Adresse wurde ge\u00e4ndert.\nSollen die Daten im Adressbuch aktualisiert werden?"))) {
                return;
            }
            if (ibanChanged) {
                this.address.setIban(newAddress.getIban());
            }
            if (bicChanged) {
                this.address.setBic(newAddress.getBic());
            }
            if (nameChanged) {
                this.address.setName(newAddress.getName());
            }
            this.address.store();
            if (newAddress instanceof HibiscusAddressImpl) {
                HibiscusAddressImpl a = (HibiscusAddressImpl)newAddress;
                a.setID(this.address.getID());
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"error while storing address", (Throwable)e);
            throw new ApplicationException(i18n.tr("Speichern der Adresse fehlgeschlagen: {0}", e.getMessage()));
        }
    }

    private boolean changed(String s1, String s2, boolean exact) {
        if (exact) {
            return !Objects.equals(s1, s2);
        }
        return !Objects.equals(this.prepare(s1), this.prepare(s2));
    }

    private String prepare(String s) {
        if (s == null) {
            return s;
        }
        return s.replace(" ", "").toLowerCase();
    }
}

