/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.KontoDeleteDialog;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;

public class KontoDelete
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (context == null || !(context instanceof Konto)) {
            throw new ApplicationException(i18n.tr("Kein Konto ausgew\u00e4hlt"));
        }
        try {
            Konto k = (Konto)context;
            if (k.isNewObject()) {
                return;
            }
            KontoDeleteDialog d = new KontoDeleteDialog(k);
            try {
                Boolean choice = (Boolean)d.open();
                if (choice == null || !choice.booleanValue()) {
                    return;
                }
            }
            catch (OperationCanceledException oce) {
                return;
            }
            catch (Exception e) {
                Logger.error((String)"error while deleting konto", (Throwable)e);
                return;
            }
            k.delete();
            GUI.getStatusBar().setSuccessText(i18n.tr("Konto gel\u00f6scht."));
        }
        catch (RemoteException e) {
            GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim L\u00f6schen des Kontos."));
            Logger.error((String)"unable to delete konto", (Throwable)e);
        }
    }
}

