/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.Dauerauftrag;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class KontoDisable
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (context == null || !(context instanceof Konto)) {
            return;
        }
        Konto k = (Konto)context;
        try {
            if (k.hasFlag(1)) {
                return;
            }
            String s = i18n.tr("Sind Sie sicher, dass Sie das Konto deaktivieren m\u00f6chten?\n\nDer Saldo wird hierbei gel\u00f6scht. Gesch\u00e4ftsvorf\u00e4lle k\u00f6nnen anschlie\u00dfend\nnicht mehr \u00fcber dieses Konto ausgef\u00fchrt werden.");
            if (!Application.getCallback().askUser(s)) {
                return;
            }
            k.transactionBegin();
            k.reset();
            k.setFlags(k.getFlags() | 1);
            k.store();
            Logger.info((String)("disabled account id: " + k.getID()));
            DBIterator dalist = k.getDauerauftraege();
            while (dalist.hasNext()) {
                Dauerauftrag da = (Dauerauftrag)dalist.next();
                if (!da.isActive()) continue;
                Logger.info((String)("  removing order id from da: " + da.getID() + ", order id: " + da.getOrderID()));
                da.setOrderID(null);
                da.store();
            }
            k.transactionCommit();
            Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)k));
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Konto deaktiviert"), 0));
        }
        catch (Exception e) {
            try {
                k.transactionRollback();
            }
            catch (Exception e1) {
                Logger.error((String)"unable to rollback transaction", (Throwable)e1);
            }
            if (e instanceof ApplicationException) {
                throw (ApplicationException)((Object)e);
            }
            Logger.error((String)"error while disabling account", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Deaktivieren des Kontos"));
        }
    }
}

