/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.PassportRegistry;
import de.willuhn.jameica.hbci.gui.action.KontoMerge;
import de.willuhn.jameica.hbci.gui.dialogs.PassportAuswahlDialog;
import de.willuhn.jameica.hbci.gui.views.KontoList;
import de.willuhn.jameica.hbci.passport.Passport;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class KontoFetchFromPassport
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        Passport passport;
        block9: {
            passport = null;
            try {
                if (context instanceof Konto) {
                    try {
                        Konto k = (Konto)context;
                        passport = PassportRegistry.findByClass(k.getPassportClass());
                        break block9;
                    }
                    catch (ApplicationException ae) {
                        throw ae;
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while reading passport from select box", (Throwable)e);
                        throw new ApplicationException(i18n.tr("Fehler beim Auslesen der Konto-Informationen"));
                    }
                }
                if (context instanceof Passport) {
                    passport = (Passport)context;
                } else {
                    PassportAuswahlDialog d = new PassportAuswahlDialog(1);
                    passport = (Passport)d.open();
                }
            }
            catch (OperationCanceledException | ApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.error((String)"unable to select passport", (Throwable)e);
                throw new ApplicationException(i18n.tr("Auswahl des Bank-Zugangs fehlgeschlagen"), (Throwable)e);
            }
        }
        final Passport p = passport;
        GUI.startSync((Runnable)new Runnable(){

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                try {
                    try {
                        GUI.getStatusBar().startProgress();
                        GUI.getStatusBar().setSuccessText(i18n.tr("Bank-Zugang wird ausgelesen..."));
                        new KontoMerge().handleAction(p.getHandle().getKonten());
                        GUI.startView(KontoList.class, null);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        GUI.getStatusBar().stopProgress();
                    }
                    catch (ApplicationException ae) {
                        GUI.getStatusBar().setErrorText(ae.getMessage());
                        GUI.getStatusBar().stopProgress();
                    }
                    catch (Throwable t) {
                        Logger.error((String)"error while reading data from passport", (Throwable)t);
                        GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Lesen der Konto-Daten. Bitte pr\u00fcfen Sie die Einstellungen des Bank-Zugangs."));
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        GUI.getStatusBar().stopProgress();
                    }
                }
                finally {
                    GUI.getStatusBar().stopProgress();
                }
            }
        });
    }
}

