/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.KontoAuswahlDialog;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobKontoauszugPdf;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Arrays;

public class KontoFetchKontoauszug
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        Konto k = null;
        if (context instanceof Konto) {
            k = (Konto)context;
        }
        KontoAuswahlDialog d = new KontoAuswahlDialog(k, KontoFilter.createForeign(SynchronizeJobKontoauszugPdf.class), 1);
        try {
            k = (Konto)d.open();
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
            return;
        }
        catch (Exception e) {
            Logger.error((String)"error while choosing konto", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler bei der Auswahl des Kontos"), 1));
        }
        if (k == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus"));
        }
        Class<SynchronizeJobKontoauszugPdf> type = SynchronizeJobKontoauszugPdf.class;
        BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        SynchronizeEngine engine = (SynchronizeEngine)bs.get(SynchronizeEngine.class);
        SynchronizeBackend backend = engine.getBackend(type, k);
        SynchronizeJob job = (SynchronizeJob)backend.create(type, k);
        job.setContext("ctx.entity", k);
        job.setContext("ctx.konto.kontoauszugpdf.force", true);
        backend.execute(Arrays.asList(job));
    }
}

