/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.KontoAuswahlDialog;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaDauerauftragList;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Arrays;

public class KontoFetchSepaDauerauftraege
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (!(context instanceof Konto)) {
            KontoAuswahlDialog d = new KontoAuswahlDialog(null, KontoFilter.createForeign(SynchronizeJobSepaDauerauftragList.class), 1);
            try {
                context = d.open();
            }
            catch (OperationCanceledException oce) {
                Logger.info((String)"operation cancelled");
                return;
            }
            catch (Exception e) {
                Logger.error((String)"error while choosing konto", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler bei der Auswahl des Kontos"), 1));
            }
        }
        if (!(context instanceof Konto)) {
            throw new ApplicationException(i18n.tr("Kein Konto ausgew\u00e4hlt"));
        }
        Konto konto = (Konto)context;
        Class<SynchronizeJobSepaDauerauftragList> type = SynchronizeJobSepaDauerauftragList.class;
        BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        SynchronizeEngine engine = (SynchronizeEngine)bs.get(SynchronizeEngine.class);
        SynchronizeBackend backend = engine.getBackend(type, konto);
        SynchronizeJob job = (SynchronizeJob)backend.create(type, konto);
        job.setContext("ctx.entity", konto);
        backend.execute(Arrays.asList(job));
    }
}

