/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.KontoAuswahlDialog;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobKontoauszug;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Arrays;

public class KontoFetchUmsaetze
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        Konto konto = context instanceof Konto ? (Konto)context : null;
        try {
            Class<SynchronizeJobKontoauszug> type = SynchronizeJobKontoauszug.class;
            if (konto == null) {
                KontoAuswahlDialog d = new KontoAuswahlDialog(null, KontoFilter.createForeign(type), 1);
                konto = (Konto)d.open();
            }
            if (konto == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus"));
            }
            if (konto.isNewObject()) {
                konto.store();
            }
            BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            SynchronizeEngine engine = (SynchronizeEngine)bs.get(SynchronizeEngine.class);
            SynchronizeBackend backend = engine.getBackend(type, konto);
            SynchronizeJob job = (SynchronizeJob)backend.create(type, konto);
            job.setContext("ctx.entity", konto);
            job.setContext("ctx.konto.saldo.force", true);
            job.setContext("ctx.konto.umsatz.force", true);
            backend.execute(Arrays.asList(job));
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (OperationCanceledException ae) {
        }
        catch (Exception e) {
            Logger.error((String)"unable to fetch bookings", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Abrufen der Ums\u00e4tze"), 1));
        }
    }
}

