/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KontoMerge
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (context == null) {
            return;
        }
        boolean kontoCheck = Settings.getKontoCheck();
        try {
            Settings.setKontoCheck(false);
            ArrayList<Konto> konten = new ArrayList<Konto>();
            if (context instanceof Konto) {
                konten.add((Konto)context);
            } else if (context instanceof Konto[]) {
                konten.addAll(Arrays.asList((Konto[])context));
            } else if (context instanceof List) {
                konten.addAll((List)context);
            }
            if (konten.size() == 0) {
                return;
            }
            try {
                DBIterator existing = Settings.getDBService().createList(Konto.class);
                int created = 0;
                int skipped = 0;
                int nosupport = 0;
                for (Konto konto : konten) {
                    Logger.info((String)("merging konto " + konto.getKontonummer()));
                    boolean found = false;
                    Logger.info((String)"  checking if already exists");
                    while (existing.hasNext()) {
                        boolean haveType;
                        String pp;
                        Konto check = (Konto)existing.next();
                        if (!check.getBLZ().equals(konto.getBLZ()) || !check.getKontonummer().equals(konto.getKontonummer()) || !check.getKundennummer().equals(konto.getKundennummer()) || (pp = check.getPassportClass()) == null || !pp.equals(konto.getPassportClass())) continue;
                        Integer localType = check.getAccountType();
                        Integer newType = konto.getAccountType();
                        boolean bl = haveType = localType != null && newType != null;
                        if (haveType && !newType.equals(localType)) continue;
                        found = true;
                        Logger.info((String)"  konto exists, skipping");
                        ++skipped;
                    }
                    existing.begin();
                    if (found) continue;
                    Logger.info((String)"saving new konto");
                    try {
                        konto.store();
                        ++created;
                        Logger.info((String)"konto saved successfully");
                    }
                    catch (ApplicationException ae) {
                        Logger.warn((String)("konto not supported: " + ae.getMessage()));
                        ++nosupport;
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while storing konto", (Throwable)e);
                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Anlegen des Kontos {0}: {1}", new String[]{konto.getLongName(), e.getMessage()}), 1));
                    }
                }
                String[] values = new String[]{Integer.toString(created), Integer.toString(skipped), Integer.toString(nosupport)};
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Konten abgeglichen. Angelegt: {0}, \u00dcbersprungen: {1}, nicht unterst\u00fctzt: {2}", values), 0));
            }
            catch (Exception e) {
                Logger.error((String)"error while merging accounts", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Anlegen der Konten: {0}", e.getMessage()), 1));
            }
        }
        finally {
            Settings.setKontoCheck(kontoCheck);
        }
    }
}

