/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class KontoRecalculateOfflineSaldo
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (context == null || !(context instanceof Konto)) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus"));
        }
        try {
            Konto k = (Konto)context;
            if (k.isNewObject()) {
                return;
            }
            String q = i18n.tr("Die Umsatzsalden werden ab dem letzten gepr\u00fcften Umsatz neu berechnet.\nSollte es keinen geben, werden alle Salden neu berechnet, wobei der Kontoanfangssaldo 0,00 angenommen wird.");
            if (!Application.getCallback().askUser(q)) {
                return;
            }
            Umsatz newer = null;
            ArrayList<Umsatz> umsaetze = new ArrayList<Umsatz>();
            DBIterator it = k.getUmsaetze();
            double currentSaldo = 0.0;
            while (it.hasNext()) {
                Umsatz um = (Umsatz)it.next();
                this.checkOrder(um, newer);
                if (um.hasFlag(1)) {
                    currentSaldo = um.getSaldo();
                    break;
                }
                umsaetze.add(um);
                newer = um;
            }
            Collections.reverse(umsaetze);
            for (Umsatz umsatz : umsaetze) {
                umsatz.setSaldo(currentSaldo += umsatz.getBetrag());
                umsatz.store();
            }
            k.setSaldo(currentSaldo);
            k.store();
            Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)k));
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Salden neu berechnet."), 0));
        }
        catch (Exception e) {
            Logger.error((String)"error while recalculating balances", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Berechnen der Salden."), 1));
            return;
        }
    }

    private void checkOrder(Umsatz current, Umsatz newer) throws RemoteException, ApplicationException {
        if (newer == null) {
            return;
        }
        Date dc = (Date)current.getAttribute("datum_pseudo");
        Date dn = (Date)newer.getAttribute("datum_pseudo");
        if (dn.before(dc)) {
            throw new ApplicationException(i18n.tr("Reihenfolge der Buchungsdaten falsch. Buchung Nr. {0} befindet sich vor Buchung Nr. {1}", new String[]{newer.getID(), current.getID()}));
        }
    }
}

