/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class KontoResetAuszugsdatum
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (context == null || !(context instanceof Konto)) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus"));
        }
        try {
            Konto k = (Konto)context;
            if (k.isNewObject()) {
                return;
            }
            String q = i18n.tr("Sollen Saldo und Aktualisierungsdatum wirklich zur\u00fcckgesetzt werden?");
            if (!k.hasFlag(2)) {
                q = String.valueOf(q) + "\n\n";
                q = String.valueOf(q) + i18n.tr("Bei der n\u00e4chsten Synchronisierung werden alle bei der Bank verf\u00fcgbaren\nUms\u00e4tze erneut abgerufen und Saldo sowie Datum aktualisiert.");
            }
            if (!Application.getCallback().askUser(q)) {
                return;
            }
            k.reset();
            k.store();
            Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)k));
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Datum zur\u00fcckgesetzt."), 0));
        }
        catch (Exception e) {
            Logger.error((String)"error while resetting saldo_date", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Zur\u00fccksetzen des Datums"), 1));
            return;
        }
    }
}

