/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.rmi.RemoteException;

public class KontoSyncViaScripting
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        if (context == null || !(context instanceof Konto)) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus"));
        }
        final Konto k = (Konto)context;
        try {
            if (!k.hasFlag(2)) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Offline-Konto aus"));
            }
            if (k.isNewObject()) {
                k.store();
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while syncing konto", (Throwable)e);
            GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Synchronisieren des Kontos"));
        }
        final AbstractView currentView = GUI.getCurrentView();
        Application.getController().start(new BackgroundTask(){

            public void run(ProgressMonitor monitor) throws ApplicationException {
                monitor.setStatus(2);
                monitor.setStatusText(i18n.tr("Starte Synchronisierung"));
                QueryMessage msg = new QueryMessage("hibiscus.konto.sync", (Object)new Object[]{k, monitor});
                Application.getMessagingFactory().getMessagingQueue("jameica.scripting").sendSyncMessage((Message)msg);
                AbstractView newView = GUI.getCurrentView();
                if (newView == currentView) {
                    currentView.reload();
                }
                monitor.setPercentComplete(100);
                Object value = msg.getData();
                if (value instanceof Throwable) {
                    Throwable t = (Throwable)value;
                    monitor.setStatus(3);
                    monitor.setStatusText(i18n.tr("Fehler: {0}", t.getMessage()));
                } else {
                    monitor.setStatus(4);
                    monitor.setStatusText(i18n.tr("Synchronisierung erfolgreich beendet"));
                }
            }

            public boolean isInterrupted() {
                return false;
            }

            public void interrupt() {
            }
        });
    }
}

