/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.YesNoDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Kontoauszug;
import de.willuhn.jameica.hbci.server.KontoauszugPdfUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class KontoauszugDelete
implements Action {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void handleAction(Object context) throws ApplicationException {
        Kontoauszug[] list = null;
        if (context instanceof Kontoauszug) {
            list = new Kontoauszug[]{(Kontoauszug)context};
        } else if (context instanceof Kontoauszug[]) {
            list = (Kontoauszug[])context;
        }
        if (list == null || list.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Kontoausz\u00fcge aus"));
        }
        try {
            final int size = list.length;
            final String file = size == 1 ? list[0].getDateiname() : null;
            final CheckboxInput check = new CheckboxInput(false);
            YesNoDialog d = new YesNoDialog(1){

                protected void extend(Container container) throws Exception {
                    String text = null;
                    text = file != null ? this.i18n.tr("Datei \"{0}\" ebenfalls l\u00f6schen", file) : (size > 1 ? this.i18n.tr("{0} zugeh\u00f6rige Dateien ebenfalls l\u00f6schen", Integer.toString(size)) : this.i18n.tr("Zugeh\u00f6rige Datei ebenfalls l\u00f6schen"));
                    final LabelInput warn = new LabelInput("");
                    warn.setColor(Color.ERROR);
                    check.addListener(new Listener(){

                        public void handleEvent(Event event) {
                            Boolean b = (Boolean)check.getValue();
                            if (b.booleanValue()) {
                                warn.setValue((Object)(size > 1 ? i18n.tr("{0} Dateien werden gel\u00f6scht", Integer.toString(size)) : i18n.tr("Die Datei wird ebenfalls gel\u00f6scht")));
                            } else {
                                warn.setValue((Object)"");
                            }
                        }
                    });
                    container.addCheckbox(check, text);
                    container.addLabelPair("", (Input)warn);
                    super.extend(container);
                }
            };
            d.setTitle(i18n.tr("Kontoauszug l\u00f6schen"));
            d.setText(i18n.tr(size == 1 ? "Wollen Sie diesen Kontoauszug wirklich l\u00f6schen?" : "Wollen Sie diese Kontoausz\u00fcge wirklich l\u00f6schen?"));
            d.setSize(350, -1);
            Boolean choice = (Boolean)d.open();
            if (!choice.booleanValue()) {
                return;
            }
            Boolean b = (Boolean)check.getValue();
            KontoauszugPdfUtil.delete(b, list);
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
            return;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"error while deleting", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim L\u00f6schen der Kontoausz\u00fcge: {0}", e.getMessage()));
        }
    }
}

